@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.costexplorer.kotlin.inputs

import com.pulumi.aws.costexplorer.inputs.CostCategorySplitChargeRuleParameterArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property type Parameter type.
 * @property values Parameter values.
 */
public data class CostCategorySplitChargeRuleParameterArgs(
    public val type: Output<String>? = null,
    public val values: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.costexplorer.inputs.CostCategorySplitChargeRuleParameterArgs> {
    override fun toJava(): com.pulumi.aws.costexplorer.inputs.CostCategorySplitChargeRuleParameterArgs = com.pulumi.aws.costexplorer.inputs.CostCategorySplitChargeRuleParameterArgs.builder()
        .type(type?.applyValue({ args0 -> args0 }))
        .values(values?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [CostCategorySplitChargeRuleParameterArgs].
 */
@PulumiTagMarker
public class CostCategorySplitChargeRuleParameterArgsBuilder internal constructor() {
    private var type: Output<String>? = null

    private var values: Output<List<String>>? = null

    /**
     * @param value Parameter type.
     */
    @JvmName("rsajayyobvsvnpfd")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value Parameter values.
     */
    @JvmName("qrsafniwohoskjdx")
    public suspend fun values(`value`: Output<List<String>>) {
        this.values = value
    }

    @JvmName("gogesjfiwfncgsrr")
    public suspend fun values(vararg values: Output<String>) {
        this.values = Output.all(values.asList())
    }

    /**
     * @param values Parameter values.
     */
    @JvmName("hngteprsfgfyubdc")
    public suspend fun values(values: List<Output<String>>) {
        this.values = Output.all(values)
    }

    /**
     * @param value Parameter type.
     */
    @JvmName("pnhxidathgxgyhej")
    public suspend fun type(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value Parameter values.
     */
    @JvmName("watppaxawqkwmuvb")
    public suspend fun values(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.values = mapped
    }

    /**
     * @param values Parameter values.
     */
    @JvmName("kkpeamiagrrddurc")
    public suspend fun values(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.values = mapped
    }

    internal fun build(): CostCategorySplitChargeRuleParameterArgs =
        CostCategorySplitChargeRuleParameterArgs(
            type = type,
            values = values,
        )
}
