@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.costexplorer.kotlin.inputs

import com.pulumi.aws.costexplorer.inputs.GetCostCategoryPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getCostCategory.
 * @property costCategoryArn Unique name for the Cost Category.
 * @property tags Configuration block for the specific `Tag` to use for `Expression`. See below.
 */
public data class GetCostCategoryPlainArgs(
    public val costCategoryArn: String,
    public val tags: Map<String, String>? = null,
) : ConvertibleToJava<com.pulumi.aws.costexplorer.inputs.GetCostCategoryPlainArgs> {
    override fun toJava(): com.pulumi.aws.costexplorer.inputs.GetCostCategoryPlainArgs =
        com.pulumi.aws.costexplorer.inputs.GetCostCategoryPlainArgs.builder()
            .costCategoryArn(costCategoryArn.let({ args0 -> args0 }))
            .tags(tags?.let({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() })).build()
}

/**
 * Builder for [GetCostCategoryPlainArgs].
 */
@PulumiTagMarker
public class GetCostCategoryPlainArgsBuilder internal constructor() {
    private var costCategoryArn: String? = null

    private var tags: Map<String, String>? = null

    /**
     * @param value Unique name for the Cost Category.
     */
    @JvmName("ydbjkllaadvrgdmx")
    public suspend fun costCategoryArn(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.costCategoryArn = mapped
    }

    /**
     * @param value Configuration block for the specific `Tag` to use for `Expression`. See below.
     */
    @JvmName("gmobnfrlbkgaashs")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.tags = mapped
    }

    /**
     * @param values Configuration block for the specific `Tag` to use for `Expression`. See below.
     */
    @JvmName("ksujdpkyxotceimh")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.tags = mapped
    }

    internal fun build(): GetCostCategoryPlainArgs = GetCostCategoryPlainArgs(
        costCategoryArn = costCategoryArn ?: throw PulumiNullFieldException("costCategoryArn"),
        tags = tags,
    )
}
