@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.costexplorer.kotlin.inputs

import com.pulumi.aws.costexplorer.inputs.GetTagsFilterNot.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property costCategory Configuration block for the filter that's based on `CostCategory` values. See `cost_category` block below for details.
 * @property dimension Configuration block for the specific `Dimension` to use for `Expression`. See `dimension` block below for details.
 * @property tags Tags that match your request.
 */
public data class GetTagsFilterNot(
    public val costCategory: GetTagsFilterNotCostCategory? = null,
    public val dimension: GetTagsFilterNotDimension? = null,
    public val tags: GetTagsFilterNotTags? = null,
) : ConvertibleToJava<com.pulumi.aws.costexplorer.inputs.GetTagsFilterNot> {
    override fun toJava(): com.pulumi.aws.costexplorer.inputs.GetTagsFilterNot =
        com.pulumi.aws.costexplorer.inputs.GetTagsFilterNot.builder()
            .costCategory(costCategory?.let({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .dimension(dimension?.let({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .tags(tags?.let({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [GetTagsFilterNot].
 */
@PulumiTagMarker
public class GetTagsFilterNotBuilder internal constructor() {
    private var costCategory: GetTagsFilterNotCostCategory? = null

    private var dimension: GetTagsFilterNotDimension? = null

    private var tags: GetTagsFilterNotTags? = null

    /**
     * @param value Configuration block for the filter that's based on `CostCategory` values. See `cost_category` block below for details.
     */
    @JvmName("khabswrvafaoseuh")
    public suspend fun costCategory(`value`: GetTagsFilterNotCostCategory?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.costCategory = mapped
    }

    /**
     * @param argument Configuration block for the filter that's based on `CostCategory` values. See `cost_category` block below for details.
     */
    @JvmName("iscqimvcxosfjjwl")
    public suspend fun costCategory(argument: suspend GetTagsFilterNotCostCategoryBuilder.() -> Unit) {
        val toBeMapped = GetTagsFilterNotCostCategoryBuilder().applySuspend { argument() }.build()
        val mapped = toBeMapped
        this.costCategory = mapped
    }

    /**
     * @param value Configuration block for the specific `Dimension` to use for `Expression`. See `dimension` block below for details.
     */
    @JvmName("varfwhigxubnusbf")
    public suspend fun dimension(`value`: GetTagsFilterNotDimension?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.dimension = mapped
    }

    /**
     * @param argument Configuration block for the specific `Dimension` to use for `Expression`. See `dimension` block below for details.
     */
    @JvmName("dqoxgbojxfdmwmsg")
    public suspend fun dimension(argument: suspend GetTagsFilterNotDimensionBuilder.() -> Unit) {
        val toBeMapped = GetTagsFilterNotDimensionBuilder().applySuspend { argument() }.build()
        val mapped = toBeMapped
        this.dimension = mapped
    }

    /**
     * @param value Tags that match your request.
     */
    @JvmName("jeiufdmjammqhgfl")
    public suspend fun tags(`value`: GetTagsFilterNotTags?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.tags = mapped
    }

    /**
     * @param argument Tags that match your request.
     */
    @JvmName("baygatkvapsugoij")
    public suspend fun tags(argument: suspend GetTagsFilterNotTagsBuilder.() -> Unit) {
        val toBeMapped = GetTagsFilterNotTagsBuilder().applySuspend { argument() }.build()
        val mapped = toBeMapped
        this.tags = mapped
    }

    internal fun build(): GetTagsFilterNot = GetTagsFilterNot(
        costCategory = costCategory,
        dimension = dimension,
        tags = tags,
    )
}
