@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.costexplorer.kotlin.inputs

import com.pulumi.aws.costexplorer.inputs.GetTagsFilterOr.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property costCategory Configuration block for the filter that's based on `CostCategory` values. See `cost_category` block below for details.
 * @property dimension Configuration block for the specific `Dimension` to use for `Expression`. See `dimension` block below for details.
 * @property tags Tags that match your request.
 */
public data class GetTagsFilterOr(
    public val costCategory: GetTagsFilterOrCostCategory? = null,
    public val dimension: GetTagsFilterOrDimension? = null,
    public val tags: GetTagsFilterOrTags? = null,
) : ConvertibleToJava<com.pulumi.aws.costexplorer.inputs.GetTagsFilterOr> {
    override fun toJava(): com.pulumi.aws.costexplorer.inputs.GetTagsFilterOr =
        com.pulumi.aws.costexplorer.inputs.GetTagsFilterOr.builder()
            .costCategory(costCategory?.let({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .dimension(dimension?.let({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .tags(tags?.let({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [GetTagsFilterOr].
 */
@PulumiTagMarker
public class GetTagsFilterOrBuilder internal constructor() {
    private var costCategory: GetTagsFilterOrCostCategory? = null

    private var dimension: GetTagsFilterOrDimension? = null

    private var tags: GetTagsFilterOrTags? = null

    /**
     * @param value Configuration block for the filter that's based on `CostCategory` values. See `cost_category` block below for details.
     */
    @JvmName("akgxvjiaknpqwqfv")
    public suspend fun costCategory(`value`: GetTagsFilterOrCostCategory?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.costCategory = mapped
    }

    /**
     * @param argument Configuration block for the filter that's based on `CostCategory` values. See `cost_category` block below for details.
     */
    @JvmName("lejstrnhlbrkjcfi")
    public suspend fun costCategory(argument: suspend GetTagsFilterOrCostCategoryBuilder.() -> Unit) {
        val toBeMapped = GetTagsFilterOrCostCategoryBuilder().applySuspend { argument() }.build()
        val mapped = toBeMapped
        this.costCategory = mapped
    }

    /**
     * @param value Configuration block for the specific `Dimension` to use for `Expression`. See `dimension` block below for details.
     */
    @JvmName("viepfqwgoseywbrv")
    public suspend fun dimension(`value`: GetTagsFilterOrDimension?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.dimension = mapped
    }

    /**
     * @param argument Configuration block for the specific `Dimension` to use for `Expression`. See `dimension` block below for details.
     */
    @JvmName("uaybsxshfnumlyxf")
    public suspend fun dimension(argument: suspend GetTagsFilterOrDimensionBuilder.() -> Unit) {
        val toBeMapped = GetTagsFilterOrDimensionBuilder().applySuspend { argument() }.build()
        val mapped = toBeMapped
        this.dimension = mapped
    }

    /**
     * @param value Tags that match your request.
     */
    @JvmName("lkqmoaynxtkbsyhc")
    public suspend fun tags(`value`: GetTagsFilterOrTags?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.tags = mapped
    }

    /**
     * @param argument Tags that match your request.
     */
    @JvmName("ewpfuktulusubbmv")
    public suspend fun tags(argument: suspend GetTagsFilterOrTagsBuilder.() -> Unit) {
        val toBeMapped = GetTagsFilterOrTagsBuilder().applySuspend { argument() }.build()
        val mapped = toBeMapped
        this.tags = mapped
    }

    internal fun build(): GetTagsFilterOr = GetTagsFilterOr(
        costCategory = costCategory,
        dimension = dimension,
        tags = tags,
    )
}
