@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.costexplorer.kotlin.inputs

import com.pulumi.aws.costexplorer.inputs.GetTagsFilterOrTags.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property key
 * @property matchOptions
 * @property values
 */
public data class GetTagsFilterOrTags(
    public val key: String? = null,
    public val matchOptions: List<String>? = null,
    public val values: List<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.costexplorer.inputs.GetTagsFilterOrTags> {
    override fun toJava(): com.pulumi.aws.costexplorer.inputs.GetTagsFilterOrTags =
        com.pulumi.aws.costexplorer.inputs.GetTagsFilterOrTags.builder()
            .key(key?.let({ args0 -> args0 }))
            .matchOptions(matchOptions?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .values(values?.let({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [GetTagsFilterOrTags].
 */
@PulumiTagMarker
public class GetTagsFilterOrTagsBuilder internal constructor() {
    private var key: String? = null

    private var matchOptions: List<String>? = null

    private var values: List<String>? = null

    /**
     * @param value
     */
    @JvmName("asuufvaejjcbwiyn")
    public suspend fun key(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.key = mapped
    }

    /**
     * @param value
     */
    @JvmName("hxwmpocvfcrtxupj")
    public suspend fun matchOptions(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.matchOptions = mapped
    }

    /**
     * @param values
     */
    @JvmName("ckdpmttbbwpoivvl")
    public suspend fun matchOptions(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.matchOptions = mapped
    }

    /**
     * @param value
     */
    @JvmName("vdyaylsifqagiani")
    public suspend fun values(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.values = mapped
    }

    /**
     * @param values
     */
    @JvmName("iksyfacuhsunlctv")
    public suspend fun values(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.values = mapped
    }

    internal fun build(): GetTagsFilterOrTags = GetTagsFilterOrTags(
        key = key,
        matchOptions = matchOptions,
        values = values,
    )
}
