@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.costexplorer.kotlin.inputs

import com.pulumi.aws.costexplorer.inputs.GetTagsTimePeriod.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property end Beginning of the time period.
 * @property start End of the time period.
 */
public data class GetTagsTimePeriod(
    public val end: String,
    public val start: String,
) : ConvertibleToJava<com.pulumi.aws.costexplorer.inputs.GetTagsTimePeriod> {
    override fun toJava(): com.pulumi.aws.costexplorer.inputs.GetTagsTimePeriod =
        com.pulumi.aws.costexplorer.inputs.GetTagsTimePeriod.builder()
            .end(end.let({ args0 -> args0 }))
            .start(start.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetTagsTimePeriod].
 */
@PulumiTagMarker
public class GetTagsTimePeriodBuilder internal constructor() {
    private var end: String? = null

    private var start: String? = null

    /**
     * @param value Beginning of the time period.
     */
    @JvmName("klrnyvpdjorvpelm")
    public suspend fun end(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.end = mapped
    }

    /**
     * @param value End of the time period.
     */
    @JvmName("qmnbescvbuyckglr")
    public suspend fun start(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.start = mapped
    }

    internal fun build(): GetTagsTimePeriod = GetTagsTimePeriod(
        end = end ?: throw PulumiNullFieldException("end"),
        start = start ?: throw PulumiNullFieldException("start"),
    )
}
