@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.costexplorer.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property address The address of the subscriber. If type is `SNS`, this will be the arn of the sns topic. If type is `EMAIL`, this will be the destination email address.
 * @property type The type of subscription. Valid Values: `SNS` | `EMAIL`.
 */
public data class AnomalySubscriptionSubscriber(
    public val address: String,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.costexplorer.outputs.AnomalySubscriptionSubscriber): AnomalySubscriptionSubscriber = AnomalySubscriptionSubscriber(
            address = javaType.address(),
            type = javaType.type(),
        )
    }
}
