@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.costexplorer.kotlin.outputs

import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property ands Return results that match both Dimension objects.
 * @property costCategory Configuration block for the filter that's based on  values. See Cost Category below.
 * @property dimension Configuration block for the specific Dimension to use for.
 * @property not Return results that match both Dimension object.
 * @property ors Return results that match both Dimension object.
 * @property tags Configuration block for the specific Tag to use for. See Tags below.
 */
public data class AnomalySubscriptionThresholdExpression(
    public val ands: List<AnomalySubscriptionThresholdExpressionAnd>? = null,
    public val costCategory: AnomalySubscriptionThresholdExpressionCostCategory? = null,
    public val dimension: AnomalySubscriptionThresholdExpressionDimension? = null,
    public val not: AnomalySubscriptionThresholdExpressionNot? = null,
    public val ors: List<AnomalySubscriptionThresholdExpressionOr>? = null,
    public val tags: AnomalySubscriptionThresholdExpressionTags? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.costexplorer.outputs.AnomalySubscriptionThresholdExpression): AnomalySubscriptionThresholdExpression = AnomalySubscriptionThresholdExpression(
            ands = javaType.ands().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.costexplorer.kotlin.outputs.AnomalySubscriptionThresholdExpressionAnd.Companion.toKotlin(args0)
                })
            }),
            costCategory = javaType.costCategory().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.costexplorer.kotlin.outputs.AnomalySubscriptionThresholdExpressionCostCategory.Companion.toKotlin(args0)
                })
            }).orElse(null),
            dimension = javaType.dimension().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.costexplorer.kotlin.outputs.AnomalySubscriptionThresholdExpressionDimension.Companion.toKotlin(args0)
                })
            }).orElse(null),
            not = javaType.not().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.costexplorer.kotlin.outputs.AnomalySubscriptionThresholdExpressionNot.Companion.toKotlin(args0)
                })
            }).orElse(null),
            ors = javaType.ors().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.costexplorer.kotlin.outputs.AnomalySubscriptionThresholdExpressionOr.Companion.toKotlin(args0)
                })
            }),
            tags = javaType.tags().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.costexplorer.kotlin.outputs.AnomalySubscriptionThresholdExpressionTags.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
