@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.costexplorer.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property inheritedValue Configuration block for the value the line item is categorized as if the line item contains the matched dimension. See below.
 * @property rule Configuration block for the `Expression` object used to categorize costs. See below.
 * @property type You can define the CostCategoryRule rule type as either `REGULAR` or `INHERITED_VALUE`.
 * @property value Default value for the cost category.
 */
public data class CostCategoryRule(
    public val inheritedValue: CostCategoryRuleInheritedValue? = null,
    public val rule: CostCategoryRuleRule? = null,
    public val type: String? = null,
    public val `value`: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.costexplorer.outputs.CostCategoryRule): CostCategoryRule = CostCategoryRule(
            inheritedValue = javaType.inheritedValue().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.costexplorer.kotlin.outputs.CostCategoryRuleInheritedValue.Companion.toKotlin(args0)
                })
            }).orElse(null),
            rule = javaType.rule().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.costexplorer.kotlin.outputs.CostCategoryRuleRule.Companion.toKotlin(args0)
                })
            }).orElse(null),
            type = javaType.type().map({ args0 -> args0 }).orElse(null),
            `value` = javaType.`value`().map({ args0 -> args0 }).orElse(null),
        )
    }
}
