@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.costexplorer.kotlin.outputs

import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property ands Return results that match both `Dimension` objects.
 * @property costCategory Configuration block for the filter that's based on `CostCategory` values. See below.
 * @property dimension Configuration block for the specific `Dimension` to use for `Expression`. See below.
 * @property not Return results that match both `Dimension` object.
 * @property ors Return results that match both `Dimension` object.
 * @property tags Configuration block for the specific `Tag` to use for `Expression`. See below.
 */
public data class CostCategoryRuleRule(
    public val ands: List<CostCategoryRuleRuleAnd>? = null,
    public val costCategory: CostCategoryRuleRuleCostCategory? = null,
    public val dimension: CostCategoryRuleRuleDimension? = null,
    public val not: CostCategoryRuleRuleNot? = null,
    public val ors: List<CostCategoryRuleRuleOr>? = null,
    public val tags: CostCategoryRuleRuleTags? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.costexplorer.outputs.CostCategoryRuleRule): CostCategoryRuleRule = CostCategoryRuleRule(
            ands = javaType.ands().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.costexplorer.kotlin.outputs.CostCategoryRuleRuleAnd.Companion.toKotlin(args0)
                })
            }),
            costCategory = javaType.costCategory().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.costexplorer.kotlin.outputs.CostCategoryRuleRuleCostCategory.Companion.toKotlin(args0)
                })
            }).orElse(null),
            dimension = javaType.dimension().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.costexplorer.kotlin.outputs.CostCategoryRuleRuleDimension.Companion.toKotlin(args0)
                })
            }).orElse(null),
            not = javaType.not().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.costexplorer.kotlin.outputs.CostCategoryRuleRuleNot.Companion.toKotlin(args0)
                })
            }).orElse(null),
            ors = javaType.ors().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.costexplorer.kotlin.outputs.CostCategoryRuleRuleOr.Companion.toKotlin(args0)
                })
            }),
            tags = javaType.tags().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.costexplorer.kotlin.outputs.CostCategoryRuleRuleTags.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
