@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.costexplorer.kotlin.outputs

import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property ands Return results that match both `Dimension` objects.
 * @property costCategory Configuration block for the filter that's based on `CostCategory` values. See below.
 * @property dimension Configuration block for the specific `Dimension` to use for `Expression`. See below.
 * @property not Return results that match both `Dimension` object.
 * @property ors Return results that match both `Dimension` object.
 * @property tags Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class CostCategoryRuleRuleAnd(
    public val ands: List<CostCategoryRuleRuleAndAnd>? = null,
    public val costCategory: CostCategoryRuleRuleAndCostCategory? = null,
    public val dimension: CostCategoryRuleRuleAndDimension? = null,
    public val not: CostCategoryRuleRuleAndNot? = null,
    public val ors: List<CostCategoryRuleRuleAndOr>? = null,
    public val tags: CostCategoryRuleRuleAndTags? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.costexplorer.outputs.CostCategoryRuleRuleAnd): CostCategoryRuleRuleAnd = CostCategoryRuleRuleAnd(
            ands = javaType.ands().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.costexplorer.kotlin.outputs.CostCategoryRuleRuleAndAnd.Companion.toKotlin(args0)
                })
            }),
            costCategory = javaType.costCategory().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.costexplorer.kotlin.outputs.CostCategoryRuleRuleAndCostCategory.Companion.toKotlin(args0)
                })
            }).orElse(null),
            dimension = javaType.dimension().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.costexplorer.kotlin.outputs.CostCategoryRuleRuleAndDimension.Companion.toKotlin(args0)
                })
            }).orElse(null),
            not = javaType.not().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.costexplorer.kotlin.outputs.CostCategoryRuleRuleAndNot.Companion.toKotlin(args0)
                })
            }).orElse(null),
            ors = javaType.ors().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.costexplorer.kotlin.outputs.CostCategoryRuleRuleAndOr.Companion.toKotlin(args0)
                })
            }),
            tags = javaType.tags().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.costexplorer.kotlin.outputs.CostCategoryRuleRuleAndTags.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
