@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.costexplorer.kotlin.outputs

import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property ands Return results that match both `Dimension` objects.
 * @property costCategory Configuration block for the filter that's based on `CostCategory` values. See below.
 * @property dimension Configuration block for the specific `Dimension` to use for `Expression`. See below.
 * @property not Return results that match both `Dimension` object.
 * @property ors Return results that match both `Dimension` object.
 * @property tags Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class CostCategoryRuleRuleNot(
    public val ands: List<CostCategoryRuleRuleNotAnd>? = null,
    public val costCategory: CostCategoryRuleRuleNotCostCategory? = null,
    public val dimension: CostCategoryRuleRuleNotDimension? = null,
    public val not: CostCategoryRuleRuleNotNot? = null,
    public val ors: List<CostCategoryRuleRuleNotOr>? = null,
    public val tags: CostCategoryRuleRuleNotTags? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.costexplorer.outputs.CostCategoryRuleRuleNot): CostCategoryRuleRuleNot = CostCategoryRuleRuleNot(
            ands = javaType.ands().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.costexplorer.kotlin.outputs.CostCategoryRuleRuleNotAnd.Companion.toKotlin(args0)
                })
            }),
            costCategory = javaType.costCategory().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.costexplorer.kotlin.outputs.CostCategoryRuleRuleNotCostCategory.Companion.toKotlin(args0)
                })
            }).orElse(null),
            dimension = javaType.dimension().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.costexplorer.kotlin.outputs.CostCategoryRuleRuleNotDimension.Companion.toKotlin(args0)
                })
            }).orElse(null),
            not = javaType.not().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.costexplorer.kotlin.outputs.CostCategoryRuleRuleNotNot.Companion.toKotlin(args0)
                })
            }).orElse(null),
            ors = javaType.ors().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.costexplorer.kotlin.outputs.CostCategoryRuleRuleNotOr.Companion.toKotlin(args0)
                })
            }),
            tags = javaType.tags().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.costexplorer.kotlin.outputs.CostCategoryRuleRuleNotTags.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
