@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.costexplorer.kotlin.outputs

import kotlin.Suppress

/**
 *
 * @property costCategory Configuration block for the filter that's based on `CostCategory` values. See below.
 * @property dimension Configuration block for the specific `Dimension` to use for `Expression`. See below.
 * @property tags Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class CostCategoryRuleRuleNotOr(
    public val costCategory: CostCategoryRuleRuleNotOrCostCategory? = null,
    public val dimension: CostCategoryRuleRuleNotOrDimension? = null,
    public val tags: CostCategoryRuleRuleNotOrTags? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.costexplorer.outputs.CostCategoryRuleRuleNotOr): CostCategoryRuleRuleNotOr = CostCategoryRuleRuleNotOr(
            costCategory = javaType.costCategory().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.costexplorer.kotlin.outputs.CostCategoryRuleRuleNotOrCostCategory.Companion.toKotlin(args0)
                })
            }).orElse(null),
            dimension = javaType.dimension().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.costexplorer.kotlin.outputs.CostCategoryRuleRuleNotOrDimension.Companion.toKotlin(args0)
                })
            }).orElse(null),
            tags = javaType.tags().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.costexplorer.kotlin.outputs.CostCategoryRuleRuleNotOrTags.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
