@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.costexplorer.kotlin.outputs

import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property ands Return results that match both `Dimension` objects.
 * @property costCategory Configuration block for the filter that's based on `CostCategory` values. See below.
 * @property dimension Configuration block for the specific `Dimension` to use for `Expression`. See below.
 * @property not Return results that match both `Dimension` object.
 * @property ors Return results that match both `Dimension` object.
 * @property tags Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class CostCategoryRuleRuleOr(
    public val ands: List<CostCategoryRuleRuleOrAnd>? = null,
    public val costCategory: CostCategoryRuleRuleOrCostCategory? = null,
    public val dimension: CostCategoryRuleRuleOrDimension? = null,
    public val not: CostCategoryRuleRuleOrNot? = null,
    public val ors: List<CostCategoryRuleRuleOrOr>? = null,
    public val tags: CostCategoryRuleRuleOrTags? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.costexplorer.outputs.CostCategoryRuleRuleOr): CostCategoryRuleRuleOr = CostCategoryRuleRuleOr(
            ands = javaType.ands().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.costexplorer.kotlin.outputs.CostCategoryRuleRuleOrAnd.Companion.toKotlin(args0)
                })
            }),
            costCategory = javaType.costCategory().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.costexplorer.kotlin.outputs.CostCategoryRuleRuleOrCostCategory.Companion.toKotlin(args0)
                })
            }).orElse(null),
            dimension = javaType.dimension().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.costexplorer.kotlin.outputs.CostCategoryRuleRuleOrDimension.Companion.toKotlin(args0)
                })
            }).orElse(null),
            not = javaType.not().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.costexplorer.kotlin.outputs.CostCategoryRuleRuleOrNot.Companion.toKotlin(args0)
                })
            }).orElse(null),
            ors = javaType.ors().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.costexplorer.kotlin.outputs.CostCategoryRuleRuleOrOr.Companion.toKotlin(args0)
                })
            }),
            tags = javaType.tags().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.costexplorer.kotlin.outputs.CostCategoryRuleRuleOrTags.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
