@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.costexplorer.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * A collection of values returned by getCostCategory.
 * @property costCategoryArn
 * @property defaultValue Default value for the cost category.
 * @property effectiveEnd Effective end data of your Cost Category.
 * @property effectiveStart Effective state data of your Cost Category.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property name
 * @property ruleVersion Rule schema version in this particular Cost Category.
 * @property rules Configuration block for the `Expression` object used to categorize costs. See below.
 * @property splitChargeRules Configuration block for the split charge rules used to allocate your charges between your Cost Category values. See below.
 * @property tags Configuration block for the specific `Tag` to use for `Expression`. See below.
 */
public data class GetCostCategoryResult(
    public val costCategoryArn: String,
    public val defaultValue: String,
    public val effectiveEnd: String,
    public val effectiveStart: String,
    public val id: String,
    public val name: String,
    public val ruleVersion: String,
    public val rules: List<GetCostCategoryRule>,
    public val splitChargeRules: List<GetCostCategorySplitChargeRule>,
    public val tags: Map<String, String>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.costexplorer.outputs.GetCostCategoryResult): GetCostCategoryResult = GetCostCategoryResult(
            costCategoryArn = javaType.costCategoryArn(),
            defaultValue = javaType.defaultValue(),
            effectiveEnd = javaType.effectiveEnd(),
            effectiveStart = javaType.effectiveStart(),
            id = javaType.id(),
            name = javaType.name(),
            ruleVersion = javaType.ruleVersion(),
            rules = javaType.rules().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.costexplorer.kotlin.outputs.GetCostCategoryRule.Companion.toKotlin(args0)
                })
            }),
            splitChargeRules = javaType.splitChargeRules().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.costexplorer.kotlin.outputs.GetCostCategorySplitChargeRule.Companion.toKotlin(args0)
                })
            }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
        )
    }
}
