@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.costexplorer.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property dimensionKey Key to extract cost category values.
 * @property dimensionName Name of the dimension that's used to group costs. If you specify `LINKED_ACCOUNT_NAME`, the cost category value is based on account name. If you specify `TAG`, the cost category value will be based on the value of the specified tag key. Valid values are `LINKED_ACCOUNT_NAME`, `TAG`
 */
public data class GetCostCategoryRuleInheritedValue(
    public val dimensionKey: String,
    public val dimensionName: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.costexplorer.outputs.GetCostCategoryRuleInheritedValue): GetCostCategoryRuleInheritedValue = GetCostCategoryRuleInheritedValue(
            dimensionKey = javaType.dimensionKey(),
            dimensionName = javaType.dimensionName(),
        )
    }
}
