@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.costexplorer.kotlin.outputs

import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property ands Return results that match both `Dimension` objects.
 * @property costCategories Configuration block for the filter that's based on `CostCategory` values. See below.
 * @property dimensions Configuration block for the specific `Dimension` to use for `Expression`. See below.
 * @property nots Return results that do not match the `Dimension` object.
 * @property ors Return results that match either `Dimension` object.
 * @property tags Configuration block for the specific `Tag` to use for `Expression`. See below.
 */
public data class GetCostCategoryRuleRuleAnd(
    public val ands: List<GetCostCategoryRuleRuleAndAnd>,
    public val costCategories: List<GetCostCategoryRuleRuleAndCostCategory>,
    public val dimensions: List<GetCostCategoryRuleRuleAndDimension>,
    public val nots: List<GetCostCategoryRuleRuleAndNot>,
    public val ors: List<GetCostCategoryRuleRuleAndOr>,
    public val tags: List<GetCostCategoryRuleRuleAndTag>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.costexplorer.outputs.GetCostCategoryRuleRuleAnd): GetCostCategoryRuleRuleAnd = GetCostCategoryRuleRuleAnd(
            ands = javaType.ands().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.costexplorer.kotlin.outputs.GetCostCategoryRuleRuleAndAnd.Companion.toKotlin(args0)
                })
            }),
            costCategories = javaType.costCategories().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.costexplorer.kotlin.outputs.GetCostCategoryRuleRuleAndCostCategory.Companion.toKotlin(args0)
                })
            }),
            dimensions = javaType.dimensions().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.costexplorer.kotlin.outputs.GetCostCategoryRuleRuleAndDimension.Companion.toKotlin(args0)
                })
            }),
            nots = javaType.nots().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.costexplorer.kotlin.outputs.GetCostCategoryRuleRuleAndNot.Companion.toKotlin(args0)
                })
            }),
            ors = javaType.ors().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.costexplorer.kotlin.outputs.GetCostCategoryRuleRuleAndOr.Companion.toKotlin(args0)
                })
            }),
            tags = javaType.tags().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.costexplorer.kotlin.outputs.GetCostCategoryRuleRuleAndTag.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
