@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.costexplorer.kotlin.outputs

import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property ands Return results that match both `Dimension` objects.
 * @property costCategories Configuration block for the filter that's based on `CostCategory` values. See below.
 * @property dimensions Configuration block for the specific `Dimension` to use for `Expression`. See below.
 * @property nots Return results that do not match the `Dimension` object.
 * @property ors Return results that match either `Dimension` object.
 * @property tags Configuration block for the specific `Tag` to use for `Expression`. See below.
 */
public data class GetCostCategoryRuleRuleNot(
    public val ands: List<GetCostCategoryRuleRuleNotAnd>,
    public val costCategories: List<GetCostCategoryRuleRuleNotCostCategory>,
    public val dimensions: List<GetCostCategoryRuleRuleNotDimension>,
    public val nots: List<GetCostCategoryRuleRuleNotNot>,
    public val ors: List<GetCostCategoryRuleRuleNotOr>,
    public val tags: List<GetCostCategoryRuleRuleNotTag>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.costexplorer.outputs.GetCostCategoryRuleRuleNot): GetCostCategoryRuleRuleNot = GetCostCategoryRuleRuleNot(
            ands = javaType.ands().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.costexplorer.kotlin.outputs.GetCostCategoryRuleRuleNotAnd.Companion.toKotlin(args0)
                })
            }),
            costCategories = javaType.costCategories().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.costexplorer.kotlin.outputs.GetCostCategoryRuleRuleNotCostCategory.Companion.toKotlin(args0)
                })
            }),
            dimensions = javaType.dimensions().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.costexplorer.kotlin.outputs.GetCostCategoryRuleRuleNotDimension.Companion.toKotlin(args0)
                })
            }),
            nots = javaType.nots().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.costexplorer.kotlin.outputs.GetCostCategoryRuleRuleNotNot.Companion.toKotlin(args0)
                })
            }),
            ors = javaType.ors().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.costexplorer.kotlin.outputs.GetCostCategoryRuleRuleNotOr.Companion.toKotlin(args0)
                })
            }),
            tags = javaType.tags().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.costexplorer.kotlin.outputs.GetCostCategoryRuleRuleNotTag.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
