@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.costexplorer.kotlin.outputs

import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property costCategories Configuration block for the filter that's based on `CostCategory` values. See below.
 * @property dimensions Configuration block for the specific `Dimension` to use for `Expression`. See below.
 * @property tags Configuration block for the specific `Tag` to use for `Expression`. See below.
 */
public data class GetCostCategoryRuleRuleNotAnd(
    public val costCategories: List<GetCostCategoryRuleRuleNotAndCostCategory>,
    public val dimensions: List<GetCostCategoryRuleRuleNotAndDimension>,
    public val tags: List<GetCostCategoryRuleRuleNotAndTag>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.costexplorer.outputs.GetCostCategoryRuleRuleNotAnd): GetCostCategoryRuleRuleNotAnd = GetCostCategoryRuleRuleNotAnd(
            costCategories = javaType.costCategories().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.costexplorer.kotlin.outputs.GetCostCategoryRuleRuleNotAndCostCategory.Companion.toKotlin(args0)
                })
            }),
            dimensions = javaType.dimensions().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.costexplorer.kotlin.outputs.GetCostCategoryRuleRuleNotAndDimension.Companion.toKotlin(args0)
                })
            }),
            tags = javaType.tags().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.costexplorer.kotlin.outputs.GetCostCategoryRuleRuleNotAndTag.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
