@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.costexplorer.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property key Key for the tag.
 * @property matchOptions Match options that you can use to filter your results. MatchOptions is only applicable for actions related to cost category. The default values for MatchOptions is `EQUALS` and `CASE_SENSITIVE`. Valid values are: `EQUALS`,  `ABSENT`, `STARTS_WITH`, `ENDS_WITH`, `CONTAINS`, `CASE_SENSITIVE`, `CASE_INSENSITIVE`.
 * @property values Parameter values.
 */
public data class GetCostCategoryRuleRuleOrDimension(
    public val key: String,
    public val matchOptions: List<String>,
    public val values: List<String>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.costexplorer.outputs.GetCostCategoryRuleRuleOrDimension): GetCostCategoryRuleRuleOrDimension = GetCostCategoryRuleRuleOrDimension(
            key = javaType.key(),
            matchOptions = javaType.matchOptions().map({ args0 -> args0 }),
            values = javaType.values().map({ args0 -> args0 }),
        )
    }
}
