@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.costexplorer.kotlin.outputs

import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property costCategories Configuration block for the filter that's based on `CostCategory` values. See below.
 * @property dimensions Configuration block for the specific `Dimension` to use for `Expression`. See below.
 * @property tags Configuration block for the specific `Tag` to use for `Expression`. See below.
 */
public data class GetCostCategoryRuleRuleOrNot(
    public val costCategories: List<GetCostCategoryRuleRuleOrNotCostCategory>,
    public val dimensions: List<GetCostCategoryRuleRuleOrNotDimension>,
    public val tags: List<GetCostCategoryRuleRuleOrNotTag>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.costexplorer.outputs.GetCostCategoryRuleRuleOrNot): GetCostCategoryRuleRuleOrNot = GetCostCategoryRuleRuleOrNot(
            costCategories = javaType.costCategories().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.costexplorer.kotlin.outputs.GetCostCategoryRuleRuleOrNotCostCategory.Companion.toKotlin(args0)
                })
            }),
            dimensions = javaType.dimensions().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.costexplorer.kotlin.outputs.GetCostCategoryRuleRuleOrNotDimension.Companion.toKotlin(args0)
                })
            }),
            tags = javaType.tags().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.costexplorer.kotlin.outputs.GetCostCategoryRuleRuleOrNotTag.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
