@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.costexplorer.kotlin.outputs

import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property costCategories Configuration block for the filter that's based on `CostCategory` values. See below.
 * @property dimensions Configuration block for the specific `Dimension` to use for `Expression`. See below.
 * @property tags Configuration block for the specific `Tag` to use for `Expression`. See below.
 */
public data class GetCostCategoryRuleRuleOrOr(
    public val costCategories: List<GetCostCategoryRuleRuleOrOrCostCategory>,
    public val dimensions: List<GetCostCategoryRuleRuleOrOrDimension>,
    public val tags: List<GetCostCategoryRuleRuleOrOrTag>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.costexplorer.outputs.GetCostCategoryRuleRuleOrOr): GetCostCategoryRuleRuleOrOr = GetCostCategoryRuleRuleOrOr(
            costCategories = javaType.costCategories().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.costexplorer.kotlin.outputs.GetCostCategoryRuleRuleOrOrCostCategory.Companion.toKotlin(args0)
                })
            }),
            dimensions = javaType.dimensions().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.costexplorer.kotlin.outputs.GetCostCategoryRuleRuleOrOrDimension.Companion.toKotlin(args0)
                })
            }),
            tags = javaType.tags().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.costexplorer.kotlin.outputs.GetCostCategoryRuleRuleOrOrTag.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
