@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.costexplorer.kotlin.outputs

import kotlin.Suppress

/**
 *
 * @property costCategory Configuration block for the filter that's based on `CostCategory` values. See `cost_category` block below for details.
 * @property dimension Configuration block for the specific `Dimension` to use for `Expression`. See `dimension` block below for details.
 * @property tags Tags that match your request.
 */
public data class GetTagsFilterOr(
    public val costCategory: GetTagsFilterOrCostCategory? = null,
    public val dimension: GetTagsFilterOrDimension? = null,
    public val tags: GetTagsFilterOrTags? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.costexplorer.outputs.GetTagsFilterOr): GetTagsFilterOr = GetTagsFilterOr(
            costCategory = javaType.costCategory().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.costexplorer.kotlin.outputs.GetTagsFilterOrCostCategory.Companion.toKotlin(args0)
                })
            }).orElse(null),
            dimension = javaType.dimension().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.costexplorer.kotlin.outputs.GetTagsFilterOrDimension.Companion.toKotlin(args0)
                })
            }).orElse(null),
            tags = javaType.tags().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.costexplorer.kotlin.outputs.GetTagsFilterOrTags.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
