@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cur.kotlin

import com.pulumi.aws.cur.ReportDefinitionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Manages Cost and Usage Report Definitions.
 * > *NOTE:* The AWS Cost and Usage Report service is only available in `us-east-1` currently.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const exampleCurReportDefinition = new aws.cur.ReportDefinition("example_cur_report_definition", {
 *     reportName: "example-cur-report-definition",
 *     timeUnit: "HOURLY",
 *     format: "textORcsv",
 *     compression: "GZIP",
 *     additionalSchemaElements: [
 *         "RESOURCES",
 *         "SPLIT_COST_ALLOCATION_DATA",
 *     ],
 *     s3Bucket: "example-bucket-name",
 *     s3Region: "us-east-1",
 *     additionalArtifacts: [
 *         "REDSHIFT",
 *         "QUICKSIGHT",
 *     ],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example_cur_report_definition = aws.cur.ReportDefinition("example_cur_report_definition",
 *     report_name="example-cur-report-definition",
 *     time_unit="HOURLY",
 *     format="textORcsv",
 *     compression="GZIP",
 *     additional_schema_elements=[
 *         "RESOURCES",
 *         "SPLIT_COST_ALLOCATION_DATA",
 *     ],
 *     s3_bucket="example-bucket-name",
 *     s3_region="us-east-1",
 *     additional_artifacts=[
 *         "REDSHIFT",
 *         "QUICKSIGHT",
 *     ])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var exampleCurReportDefinition = new Aws.Cur.ReportDefinition("example_cur_report_definition", new()
 *     {
 *         ReportName = "example-cur-report-definition",
 *         TimeUnit = "HOURLY",
 *         Format = "textORcsv",
 *         Compression = "GZIP",
 *         AdditionalSchemaElements = new[]
 *         {
 *             "RESOURCES",
 *             "SPLIT_COST_ALLOCATION_DATA",
 *         },
 *         S3Bucket = "example-bucket-name",
 *         S3Region = "us-east-1",
 *         AdditionalArtifacts = new[]
 *         {
 *             "REDSHIFT",
 *             "QUICKSIGHT",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/cur"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := cur.NewReportDefinition(ctx, "example_cur_report_definition", &cur.ReportDefinitionArgs{
 * 			ReportName:  pulumi.String("example-cur-report-definition"),
 * 			TimeUnit:    pulumi.String("HOURLY"),
 * 			Format:      pulumi.String("textORcsv"),
 * 			Compression: pulumi.String("GZIP"),
 * 			AdditionalSchemaElements: pulumi.StringArray{
 * 				pulumi.String("RESOURCES"),
 * 				pulumi.String("SPLIT_COST_ALLOCATION_DATA"),
 * 			},
 * 			S3Bucket: pulumi.String("example-bucket-name"),
 * 			S3Region: pulumi.String("us-east-1"),
 * 			AdditionalArtifacts: pulumi.StringArray{
 * 				pulumi.String("REDSHIFT"),
 * 				pulumi.String("QUICKSIGHT"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.cur.ReportDefinition;
 * import com.pulumi.aws.cur.ReportDefinitionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleCurReportDefinition = new ReportDefinition("exampleCurReportDefinition", ReportDefinitionArgs.builder()
 *             .reportName("example-cur-report-definition")
 *             .timeUnit("HOURLY")
 *             .format("textORcsv")
 *             .compression("GZIP")
 *             .additionalSchemaElements(
 *                 "RESOURCES",
 *                 "SPLIT_COST_ALLOCATION_DATA")
 *             .s3Bucket("example-bucket-name")
 *             .s3Region("us-east-1")
 *             .additionalArtifacts(
 *                 "REDSHIFT",
 *                 "QUICKSIGHT")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   exampleCurReportDefinition:
 *     type: aws:cur:ReportDefinition
 *     name: example_cur_report_definition
 *     properties:
 *       reportName: example-cur-report-definition
 *       timeUnit: HOURLY
 *       format: textORcsv
 *       compression: GZIP
 *       additionalSchemaElements:
 *         - RESOURCES
 *         - SPLIT_COST_ALLOCATION_DATA
 *       s3Bucket: example-bucket-name
 *       s3Region: us-east-1
 *       additionalArtifacts:
 *         - REDSHIFT
 *         - QUICKSIGHT
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Report Definitions using the `report_name`. For example:
 * ```sh
 * $ pulumi import aws:cur/reportDefinition:ReportDefinition example_cur_report_definition example-cur-report-definition
 * ```
 * @property additionalArtifacts A list of additional artifacts. Valid values are: `REDSHIFT`, `QUICKSIGHT`, `ATHENA`. When ATHENA exists within additional_artifacts, no other artifact type can be declared and report_versioning must be `OVERWRITE_REPORT`.
 * @property additionalSchemaElements A list of schema elements. Valid values are: `RESOURCES`, `SPLIT_COST_ALLOCATION_DATA`.
 * @property compression Compression format for report. Valid values are: `GZIP`, `ZIP`, `Parquet`. If `Parquet` is used, then format must also be `Parquet`.
 * @property format Format for report. Valid values are: `textORcsv`, `Parquet`. If `Parquet` is used, then Compression must also be `Parquet`.
 * @property refreshClosedReports Set to true to update your reports after they have been finalized if AWS detects charges related to previous months.
 * @property reportName Unique name for the report. Must start with a number/letter and is case sensitive. Limited to 256 characters.
 * @property reportVersioning Overwrite the previous version of each report or to deliver the report in addition to the previous versions. Valid values are: `CREATE_NEW_REPORT` and `OVERWRITE_REPORT`.
 * @property s3Bucket Name of the existing S3 bucket to hold generated reports.
 * @property s3Prefix Report path prefix. Limited to 256 characters.
 * @property s3Region Region of the existing S3 bucket to hold generated reports.
 * @property tags Key-value pairs of resource tags to assign to the DataSync Location. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * @property timeUnit The frequency on which report data are measured and displayed.  Valid values are: `DAILY`, `HOURLY`, `MONTHLY`.
 */
public data class ReportDefinitionArgs(
    public val additionalArtifacts: Output<List<String>>? = null,
    public val additionalSchemaElements: Output<List<String>>? = null,
    public val compression: Output<String>? = null,
    public val format: Output<String>? = null,
    public val refreshClosedReports: Output<Boolean>? = null,
    public val reportName: Output<String>? = null,
    public val reportVersioning: Output<String>? = null,
    public val s3Bucket: Output<String>? = null,
    public val s3Prefix: Output<String>? = null,
    public val s3Region: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val timeUnit: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.cur.ReportDefinitionArgs> {
    override fun toJava(): com.pulumi.aws.cur.ReportDefinitionArgs =
        com.pulumi.aws.cur.ReportDefinitionArgs.builder()
            .additionalArtifacts(additionalArtifacts?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .additionalSchemaElements(
                additionalSchemaElements?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0
                    })
                }),
            )
            .compression(compression?.applyValue({ args0 -> args0 }))
            .format(format?.applyValue({ args0 -> args0 }))
            .refreshClosedReports(refreshClosedReports?.applyValue({ args0 -> args0 }))
            .reportName(reportName?.applyValue({ args0 -> args0 }))
            .reportVersioning(reportVersioning?.applyValue({ args0 -> args0 }))
            .s3Bucket(s3Bucket?.applyValue({ args0 -> args0 }))
            .s3Prefix(s3Prefix?.applyValue({ args0 -> args0 }))
            .s3Region(s3Region?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .timeUnit(timeUnit?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ReportDefinitionArgs].
 */
@PulumiTagMarker
public class ReportDefinitionArgsBuilder internal constructor() {
    private var additionalArtifacts: Output<List<String>>? = null

    private var additionalSchemaElements: Output<List<String>>? = null

    private var compression: Output<String>? = null

    private var format: Output<String>? = null

    private var refreshClosedReports: Output<Boolean>? = null

    private var reportName: Output<String>? = null

    private var reportVersioning: Output<String>? = null

    private var s3Bucket: Output<String>? = null

    private var s3Prefix: Output<String>? = null

    private var s3Region: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var timeUnit: Output<String>? = null

    /**
     * @param value A list of additional artifacts. Valid values are: `REDSHIFT`, `QUICKSIGHT`, `ATHENA`. When ATHENA exists within additional_artifacts, no other artifact type can be declared and report_versioning must be `OVERWRITE_REPORT`.
     */
    @JvmName("hdydbwfnvycystbc")
    public suspend fun additionalArtifacts(`value`: Output<List<String>>) {
        this.additionalArtifacts = value
    }

    @JvmName("sparqiebucokdwke")
    public suspend fun additionalArtifacts(vararg values: Output<String>) {
        this.additionalArtifacts = Output.all(values.asList())
    }

    /**
     * @param values A list of additional artifacts. Valid values are: `REDSHIFT`, `QUICKSIGHT`, `ATHENA`. When ATHENA exists within additional_artifacts, no other artifact type can be declared and report_versioning must be `OVERWRITE_REPORT`.
     */
    @JvmName("oygkkelvlqnemxij")
    public suspend fun additionalArtifacts(values: List<Output<String>>) {
        this.additionalArtifacts = Output.all(values)
    }

    /**
     * @param value A list of schema elements. Valid values are: `RESOURCES`, `SPLIT_COST_ALLOCATION_DATA`.
     */
    @JvmName("epgitbgnjdwjcjfd")
    public suspend fun additionalSchemaElements(`value`: Output<List<String>>) {
        this.additionalSchemaElements = value
    }

    @JvmName("iqfwixfbekmnlhtw")
    public suspend fun additionalSchemaElements(vararg values: Output<String>) {
        this.additionalSchemaElements = Output.all(values.asList())
    }

    /**
     * @param values A list of schema elements. Valid values are: `RESOURCES`, `SPLIT_COST_ALLOCATION_DATA`.
     */
    @JvmName("cehqqbvdokqfjhcj")
    public suspend fun additionalSchemaElements(values: List<Output<String>>) {
        this.additionalSchemaElements = Output.all(values)
    }

    /**
     * @param value Compression format for report. Valid values are: `GZIP`, `ZIP`, `Parquet`. If `Parquet` is used, then format must also be `Parquet`.
     */
    @JvmName("kachakmlvrosmvkc")
    public suspend fun compression(`value`: Output<String>) {
        this.compression = value
    }

    /**
     * @param value Format for report. Valid values are: `textORcsv`, `Parquet`. If `Parquet` is used, then Compression must also be `Parquet`.
     */
    @JvmName("inxcwvmvgymgvspo")
    public suspend fun format(`value`: Output<String>) {
        this.format = value
    }

    /**
     * @param value Set to true to update your reports after they have been finalized if AWS detects charges related to previous months.
     */
    @JvmName("drrrmqpjpdshqwns")
    public suspend fun refreshClosedReports(`value`: Output<Boolean>) {
        this.refreshClosedReports = value
    }

    /**
     * @param value Unique name for the report. Must start with a number/letter and is case sensitive. Limited to 256 characters.
     */
    @JvmName("vgevucsoyidtdgbw")
    public suspend fun reportName(`value`: Output<String>) {
        this.reportName = value
    }

    /**
     * @param value Overwrite the previous version of each report or to deliver the report in addition to the previous versions. Valid values are: `CREATE_NEW_REPORT` and `OVERWRITE_REPORT`.
     */
    @JvmName("tremfbagktdubsff")
    public suspend fun reportVersioning(`value`: Output<String>) {
        this.reportVersioning = value
    }

    /**
     * @param value Name of the existing S3 bucket to hold generated reports.
     */
    @JvmName("cipwvycmroogbykq")
    public suspend fun s3Bucket(`value`: Output<String>) {
        this.s3Bucket = value
    }

    /**
     * @param value Report path prefix. Limited to 256 characters.
     */
    @JvmName("vrtgkgvnsghqwhur")
    public suspend fun s3Prefix(`value`: Output<String>) {
        this.s3Prefix = value
    }

    /**
     * @param value Region of the existing S3 bucket to hold generated reports.
     */
    @JvmName("imlielvcndqqcnrg")
    public suspend fun s3Region(`value`: Output<String>) {
        this.s3Region = value
    }

    /**
     * @param value Key-value pairs of resource tags to assign to the DataSync Location. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("tptxravgphtwyger")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The frequency on which report data are measured and displayed.  Valid values are: `DAILY`, `HOURLY`, `MONTHLY`.
     */
    @JvmName("cchsgakojmvucgsl")
    public suspend fun timeUnit(`value`: Output<String>) {
        this.timeUnit = value
    }

    /**
     * @param value A list of additional artifacts. Valid values are: `REDSHIFT`, `QUICKSIGHT`, `ATHENA`. When ATHENA exists within additional_artifacts, no other artifact type can be declared and report_versioning must be `OVERWRITE_REPORT`.
     */
    @JvmName("owgsufsjefpykmos")
    public suspend fun additionalArtifacts(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.additionalArtifacts = mapped
    }

    /**
     * @param values A list of additional artifacts. Valid values are: `REDSHIFT`, `QUICKSIGHT`, `ATHENA`. When ATHENA exists within additional_artifacts, no other artifact type can be declared and report_versioning must be `OVERWRITE_REPORT`.
     */
    @JvmName("xyhenridxgotglad")
    public suspend fun additionalArtifacts(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.additionalArtifacts = mapped
    }

    /**
     * @param value A list of schema elements. Valid values are: `RESOURCES`, `SPLIT_COST_ALLOCATION_DATA`.
     */
    @JvmName("rselguexmapooxea")
    public suspend fun additionalSchemaElements(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.additionalSchemaElements = mapped
    }

    /**
     * @param values A list of schema elements. Valid values are: `RESOURCES`, `SPLIT_COST_ALLOCATION_DATA`.
     */
    @JvmName("kmmrbpgomglbydrl")
    public suspend fun additionalSchemaElements(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.additionalSchemaElements = mapped
    }

    /**
     * @param value Compression format for report. Valid values are: `GZIP`, `ZIP`, `Parquet`. If `Parquet` is used, then format must also be `Parquet`.
     */
    @JvmName("yrvyhonhiqbncomn")
    public suspend fun compression(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.compression = mapped
    }

    /**
     * @param value Format for report. Valid values are: `textORcsv`, `Parquet`. If `Parquet` is used, then Compression must also be `Parquet`.
     */
    @JvmName("rdeajvmneupdmdwe")
    public suspend fun format(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.format = mapped
    }

    /**
     * @param value Set to true to update your reports after they have been finalized if AWS detects charges related to previous months.
     */
    @JvmName("ycnfxtkaoopjotuj")
    public suspend fun refreshClosedReports(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.refreshClosedReports = mapped
    }

    /**
     * @param value Unique name for the report. Must start with a number/letter and is case sensitive. Limited to 256 characters.
     */
    @JvmName("gjbdargfyxvqplbi")
    public suspend fun reportName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.reportName = mapped
    }

    /**
     * @param value Overwrite the previous version of each report or to deliver the report in addition to the previous versions. Valid values are: `CREATE_NEW_REPORT` and `OVERWRITE_REPORT`.
     */
    @JvmName("hbqswlkjeksicwby")
    public suspend fun reportVersioning(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.reportVersioning = mapped
    }

    /**
     * @param value Name of the existing S3 bucket to hold generated reports.
     */
    @JvmName("xkqwxdqjajkonhrc")
    public suspend fun s3Bucket(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.s3Bucket = mapped
    }

    /**
     * @param value Report path prefix. Limited to 256 characters.
     */
    @JvmName("dmqabcakcekkkoom")
    public suspend fun s3Prefix(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.s3Prefix = mapped
    }

    /**
     * @param value Region of the existing S3 bucket to hold generated reports.
     */
    @JvmName("vxvapqprarvllntf")
    public suspend fun s3Region(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.s3Region = mapped
    }

    /**
     * @param value Key-value pairs of resource tags to assign to the DataSync Location. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("ebtfhxebbglacahw")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Key-value pairs of resource tags to assign to the DataSync Location. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("wjdstexvyddudehv")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The frequency on which report data are measured and displayed.  Valid values are: `DAILY`, `HOURLY`, `MONTHLY`.
     */
    @JvmName("wsvkvhvdbccufwti")
    public suspend fun timeUnit(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.timeUnit = mapped
    }

    internal fun build(): ReportDefinitionArgs = ReportDefinitionArgs(
        additionalArtifacts = additionalArtifacts,
        additionalSchemaElements = additionalSchemaElements,
        compression = compression,
        format = format,
        refreshClosedReports = refreshClosedReports,
        reportName = reportName,
        reportVersioning = reportVersioning,
        s3Bucket = s3Bucket,
        s3Prefix = s3Prefix,
        s3Region = s3Region,
        tags = tags,
        timeUnit = timeUnit,
    )
}
