@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cur.kotlin.inputs

import com.pulumi.aws.cur.inputs.GetReportDefinitionPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getReportDefinition.
 * @property reportName Name of the report definition to match.
 * @property tags Map of key-value pairs assigned to the resource.
 */
public data class GetReportDefinitionPlainArgs(
    public val reportName: String,
    public val tags: Map<String, String>? = null,
) : ConvertibleToJava<com.pulumi.aws.cur.inputs.GetReportDefinitionPlainArgs> {
    override fun toJava(): com.pulumi.aws.cur.inputs.GetReportDefinitionPlainArgs =
        com.pulumi.aws.cur.inputs.GetReportDefinitionPlainArgs.builder()
            .reportName(reportName.let({ args0 -> args0 }))
            .tags(tags?.let({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() })).build()
}

/**
 * Builder for [GetReportDefinitionPlainArgs].
 */
@PulumiTagMarker
public class GetReportDefinitionPlainArgsBuilder internal constructor() {
    private var reportName: String? = null

    private var tags: Map<String, String>? = null

    /**
     * @param value Name of the report definition to match.
     */
    @JvmName("wywexpqdqykkylht")
    public suspend fun reportName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.reportName = mapped
    }

    /**
     * @param value Map of key-value pairs assigned to the resource.
     */
    @JvmName("pqmrtahkkkwqwehf")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.tags = mapped
    }

    /**
     * @param values Map of key-value pairs assigned to the resource.
     */
    @JvmName("qiwxoxyqgiyscyml")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.tags = mapped
    }

    internal fun build(): GetReportDefinitionPlainArgs = GetReportDefinitionPlainArgs(
        reportName = reportName ?: throw PulumiNullFieldException("reportName"),
        tags = tags,
    )
}
