@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.customerprofiles.kotlin

import com.pulumi.aws.customerprofiles.DomainArgs.builder
import com.pulumi.aws.customerprofiles.kotlin.inputs.DomainMatchingArgs
import com.pulumi.aws.customerprofiles.kotlin.inputs.DomainMatchingArgsBuilder
import com.pulumi.aws.customerprofiles.kotlin.inputs.DomainRuleBasedMatchingArgs
import com.pulumi.aws.customerprofiles.kotlin.inputs.DomainRuleBasedMatchingArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Resource for managing an Amazon Customer Profiles Domain.
 * See the [Create Domain](https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_CreateDomain.html) for more information.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.customerprofiles.Domain("example", {domainName: "example"});
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.customerprofiles.Domain("example", domain_name="example")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.CustomerProfiles.Domain("example", new()
 *     {
 *         DomainName = "example",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/customerprofiles"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := customerprofiles.NewDomain(ctx, "example", &customerprofiles.DomainArgs{
 * 			DomainName: pulumi.String("example"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.customerprofiles.Domain;
 * import com.pulumi.aws.customerprofiles.DomainArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Domain("example", DomainArgs.builder()
 *             .domainName("example")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:customerprofiles:Domain
 *     properties:
 *       domainName: example
 * ```
 * <!--End PulumiCodeChooser -->
 * ### With SQS DLQ and KMS set
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.sqs.Queue("example", {
 *     name: "example",
 *     policy: JSON.stringify({
 *         Version: "2012-10-17",
 *         Statement: [{
 *             Sid: "Customer Profiles SQS policy",
 *             Effect: "Allow",
 *             Action: ["sqs:SendMessage"],
 *             Resource: "*",
 *             Principal: {
 *                 Service: "profile.amazonaws.com",
 *             },
 *         }],
 *     }),
 * });
 * const exampleKey = new aws.kms.Key("example", {
 *     description: "example",
 *     deletionWindowInDays: 10,
 * });
 * const exampleBucketV2 = new aws.s3.BucketV2("example", {
 *     bucket: "example",
 *     forceDestroy: true,
 * });
 * const exampleBucketPolicy = new aws.s3.BucketPolicy("example", {
 *     bucket: exampleBucketV2.id,
 *     policy: pulumi.jsonStringify({
 *         Version: "2012-10-17",
 *         Statement: [{
 *             Sid: "Customer Profiles S3 policy",
 *             Effect: "Allow",
 *             Action: [
 *                 "s3:GetObject",
 *                 "s3:PutObject",
 *                 "s3:ListBucket",
 *             ],
 *             Resource: [
 *                 exampleBucketV2.arn,
 *                 pulumi.interpolate`${exampleBucketV2.arn}/*`,
 *             ],
 *             Principal: {
 *                 Service: "profile.amazonaws.com",
 *             },
 *         }],
 *     }),
 * });
 * const test = new aws.customerprofiles.Domain("test", {
 *     domainName: example,
 *     deadLetterQueueUrl: example.id,
 *     defaultEncryptionKey: exampleKey.arn,
 *     defaultExpirationDays: 365,
 * });
 * ```
 * ```python
 * import pulumi
 * import json
 * import pulumi_aws as aws
 * example = aws.sqs.Queue("example",
 *     name="example",
 *     policy=json.dumps({
 *         "Version": "2012-10-17",
 *         "Statement": [{
 *             "Sid": "Customer Profiles SQS policy",
 *             "Effect": "Allow",
 *             "Action": ["sqs:SendMessage"],
 *             "Resource": "*",
 *             "Principal": {
 *                 "Service": "profile.amazonaws.com",
 *             },
 *         }],
 *     }))
 * example_key = aws.kms.Key("example",
 *     description="example",
 *     deletion_window_in_days=10)
 * example_bucket_v2 = aws.s3.BucketV2("example",
 *     bucket="example",
 *     force_destroy=True)
 * example_bucket_policy = aws.s3.BucketPolicy("example",
 *     bucket=example_bucket_v2.id,
 *     policy=pulumi.Output.json_dumps({
 *         "Version": "2012-10-17",
 *         "Statement": [{
 *             "Sid": "Customer Profiles S3 policy",
 *             "Effect": "Allow",
 *             "Action": [
 *                 "s3:GetObject",
 *                 "s3:PutObject",
 *                 "s3:ListBucket",
 *             ],
 *             "Resource": [
 *                 example_bucket_v2.arn,
 *                 example_bucket_v2.arn.apply(lambda arn: f"{arn}/*"),
 *             ],
 *             "Principal": {
 *                 "Service": "profile.amazonaws.com",
 *             },
 *         }],
 *     }))
 * test = aws.customerprofiles.Domain("test",
 *     domain_name=example,
 *     dead_letter_queue_url=example.id,
 *     default_encryption_key=example_key.arn,
 *     default_expiration_days=365)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using System.Text.Json;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Sqs.Queue("example", new()
 *     {
 *         Name = "example",
 *         Policy = JsonSerializer.Serialize(new Dictionary<string, object?>
 *         {
 *             ["Version"] = "2012-10-17",
 *             ["Statement"] = new[]
 *             {
 *                 new Dictionary<string, object?>
 *                 {
 *                     ["Sid"] = "Customer Profiles SQS policy",
 *                     ["Effect"] = "Allow",
 *                     ["Action"] = new[]
 *                     {
 *                         "sqs:SendMessage",
 *                     },
 *                     ["Resource"] = "*",
 *                     ["Principal"] = new Dictionary<string, object?>
 *                     {
 *                         ["Service"] = "profile.amazonaws.com",
 *                     },
 *                 },
 *             },
 *         }),
 *     });
 *     var exampleKey = new Aws.Kms.Key("example", new()
 *     {
 *         Description = "example",
 *         DeletionWindowInDays = 10,
 *     });
 *     var exampleBucketV2 = new Aws.S3.BucketV2("example", new()
 *     {
 *         Bucket = "example",
 *         ForceDestroy = true,
 *     });
 *     var exampleBucketPolicy = new Aws.S3.BucketPolicy("example", new()
 *     {
 *         Bucket = exampleBucketV2.Id,
 *         Policy = Output.JsonSerialize(Output.Create(new Dictionary<string, object?>
 *         {
 *             ["Version"] = "2012-10-17",
 *             ["Statement"] = new[]
 *             {
 *                 new Dictionary<string, object?>
 *                 {
 *                     ["Sid"] = "Customer Profiles S3 policy",
 *                     ["Effect"] = "Allow",
 *                     ["Action"] = new[]
 *                     {
 *                         "s3:GetObject",
 *                         "s3:PutObject",
 *                         "s3:ListBucket",
 *                     },
 *                     ["Resource"] = new[]
 *                     {
 *                         exampleBucketV2.Arn,
 *                         exampleBucketV2.Arn.Apply(arn => $"{arn}/*"),
 *                     },
 *                     ["Principal"] = new Dictionary<string, object?>
 *                     {
 *                         ["Service"] = "profile.amazonaws.com",
 *                     },
 *                 },
 *             },
 *         })),
 *     });
 *     var test = new Aws.CustomerProfiles.Domain("test", new()
 *     {
 *         DomainName = example,
 *         DeadLetterQueueUrl = example.Id,
 *         DefaultEncryptionKey = exampleKey.Arn,
 *         DefaultExpirationDays = 365,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"encoding/json"
 * 	"fmt"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/customerprofiles"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/iam"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/kms"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/s3"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/sqs"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		tmpJSON0, err := json.Marshal(map[string]interface{}{
 * 			"Version": "2012-10-17",
 * 			"Statement": []map[string]interface{}{
 * 				map[string]interface{}{
 * 					"Sid":    "Customer Profiles SQS policy",
 * 					"Effect": "Allow",
 * 					"Action": []string{
 * 						"sqs:SendMessage",
 * 					},
 * 					"Resource": "*",
 * 					"Principal": map[string]interface{}{
 * 						"Service": "profile.amazonaws.com",
 * 					},
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		json0 := string(tmpJSON0)
 * 		example, err := sqs.NewQueue(ctx, "example", &sqs.QueueArgs{
 * 			Name:   pulumi.String("example"),
 * 			Policy: pulumi.String(json0),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		exampleKey, err := kms.NewKey(ctx, "example", &kms.KeyArgs{
 * 			Description:          pulumi.String("example"),
 * 			DeletionWindowInDays: pulumi.Int(10),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		exampleBucketV2, err := s3.NewBucketV2(ctx, "example", &s3.BucketV2Args{
 * 			Bucket:       pulumi.String("example"),
 * 			ForceDestroy: pulumi.Bool(true),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = s3.NewBucketPolicy(ctx, "example", &s3.BucketPolicyArgs{
 * 			Bucket: exampleBucketV2.ID(),
 * 			Policy: pulumi.All(exampleBucketV2.Arn, exampleBucketV2.Arn).ApplyT(func(_args []interface{}) (string, error) {
 * 				exampleBucketV2Arn := _args[0].(string)
 * 				exampleBucketV2Arn1 := _args[1].(string)
 * 				var _zero string
 * 				tmpJSON1, err := json.Marshal(map[string]interface{}{
 * 					"Version": "2012-10-17",
 * 					"Statement": []map[string]interface{}{
 * 						map[string]interface{}{
 * 							"Sid":    "Customer Profiles S3 policy",
 * 							"Effect": "Allow",
 * 							"Action": []string{
 * 								"s3:GetObject",
 * 								"s3:PutObject",
 * 								"s3:ListBucket",
 * 							},
 * 							"Resource": []string{
 * 								exampleBucketV2Arn,
 * 								fmt.Sprintf("%v/*", exampleBucketV2Arn1),
 * 							},
 * 							"Principal": map[string]interface{}{
 * 								"Service": "profile.amazonaws.com",
 * 							},
 * 						},
 * 					},
 * 				})
 * 				if err != nil {
 * 					return _zero, err
 * 				}
 * 				json1 := string(tmpJSON1)
 * 				return json1, nil
 * 			}).(pulumi.StringOutput),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = customerprofiles.NewDomain(ctx, "test", &customerprofiles.DomainArgs{
 * 			DomainName:            example,
 * 			DeadLetterQueueUrl:    example.ID(),
 * 			DefaultEncryptionKey:  exampleKey.Arn,
 * 			DefaultExpirationDays: pulumi.Int(365),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.sqs.Queue;
 * import com.pulumi.aws.sqs.QueueArgs;
 * import com.pulumi.aws.kms.Key;
 * import com.pulumi.aws.kms.KeyArgs;
 * import com.pulumi.aws.s3.BucketV2;
 * import com.pulumi.aws.s3.BucketV2Args;
 * import com.pulumi.aws.s3.BucketPolicy;
 * import com.pulumi.aws.s3.BucketPolicyArgs;
 * import com.pulumi.aws.customerprofiles.Domain;
 * import com.pulumi.aws.customerprofiles.DomainArgs;
 * import static com.pulumi.codegen.internal.Serialization.*;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Queue("example", QueueArgs.builder()
 *             .name("example")
 *             .policy(serializeJson(
 *                 jsonObject(
 *                     jsonProperty("Version", "2012-10-17"),
 *                     jsonProperty("Statement", jsonArray(jsonObject(
 *                         jsonProperty("Sid", "Customer Profiles SQS policy"),
 *                         jsonProperty("Effect", "Allow"),
 *                         jsonProperty("Action", jsonArray("sqs:SendMessage")),
 *                         jsonProperty("Resource", "*"),
 *                         jsonProperty("Principal", jsonObject(
 *                             jsonProperty("Service", "profile.amazonaws.com")
 *                         ))
 *                     )))
 *                 )))
 *             .build());
 *         var exampleKey = new Key("exampleKey", KeyArgs.builder()
 *             .description("example")
 *             .deletionWindowInDays(10)
 *             .build());
 *         var exampleBucketV2 = new BucketV2("exampleBucketV2", BucketV2Args.builder()
 *             .bucket("example")
 *             .forceDestroy(true)
 *             .build());
 *         var exampleBucketPolicy = new BucketPolicy("exampleBucketPolicy", BucketPolicyArgs.builder()
 *             .bucket(exampleBucketV2.id())
 *             .policy(Output.tuple(exampleBucketV2.arn(), exampleBucketV2.arn()).applyValue(values -> {
 *                 var exampleBucketV2Arn = values.t1;
 *                 var exampleBucketV2Arn1 = values.t2;
 *                 return serializeJson(
 *                     jsonObject(
 *                         jsonProperty("Version", "2012-10-17"),
 *                         jsonProperty("Statement", jsonArray(jsonObject(
 *                             jsonProperty("Sid", "Customer Profiles S3 policy"),
 *                             jsonProperty("Effect", "Allow"),
 *                             jsonProperty("Action", jsonArray(
 *                                 "s3:GetObject",
 *                                 "s3:PutObject",
 *                                 "s3:ListBucket"
 *                             )),
 *                             jsonProperty("Resource", jsonArray(
 *                                 exampleBucketV2Arn,
 *                                 String.format("%s/*", exampleBucketV2Arn1)
 *                             )),
 *                             jsonProperty("Principal", jsonObject(
 *                                 jsonProperty("Service", "profile.amazonaws.com")
 *                             ))
 *                         )))
 *                     ));
 *             }))
 *             .build());
 *         var test = new Domain("test", DomainArgs.builder()
 *             .domainName(example)
 *             .deadLetterQueueUrl(example.id())
 *             .defaultEncryptionKey(exampleKey.arn())
 *             .defaultExpirationDays(365)
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:sqs:Queue
 *     properties:
 *       name: example
 *       policy:
 *         fn::toJSON:
 *           Version: 2012-10-17
 *           Statement:
 *             - Sid: Customer Profiles SQS policy
 *               Effect: Allow
 *               Action:
 *                 - sqs:SendMessage
 *               Resource: '*'
 *               Principal:
 *                 Service: profile.amazonaws.com
 *   exampleKey:
 *     type: aws:kms:Key
 *     name: example
 *     properties:
 *       description: example
 *       deletionWindowInDays: 10
 *   exampleBucketV2:
 *     type: aws:s3:BucketV2
 *     name: example
 *     properties:
 *       bucket: example
 *       forceDestroy: true
 *   exampleBucketPolicy:
 *     type: aws:s3:BucketPolicy
 *     name: example
 *     properties:
 *       bucket: ${exampleBucketV2.id}
 *       policy:
 *         fn::toJSON:
 *           Version: 2012-10-17
 *           Statement:
 *             - Sid: Customer Profiles S3 policy
 *               Effect: Allow
 *               Action:
 *                 - s3:GetObject
 *                 - s3:PutObject
 *                 - s3:ListBucket
 *               Resource:
 *                 - ${exampleBucketV2.arn}
 *                 - ${exampleBucketV2.arn}/*
 *               Principal:
 *                 Service: profile.amazonaws.com
 *   test:
 *     type: aws:customerprofiles:Domain
 *     properties:
 *       domainName: ${example}
 *       deadLetterQueueUrl: ${example.id}
 *       defaultEncryptionKey: ${exampleKey.arn}
 *       defaultExpirationDays: 365
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Amazon Customer Profiles Domain using the resource `id`. For example:
 * ```sh
 * $ pulumi import aws:customerprofiles/domain:Domain example e6f777be-22d0-4b40-b307-5d2720ef16b2
 * ```
 * @property deadLetterQueueUrl The URL of the SQS dead letter queue, which is used for reporting errors associated with ingesting data from third party applications.
 * @property defaultEncryptionKey The default encryption key, which is an AWS managed key, is used when no specific type of encryption key is specified. It is used to encrypt all data before it is placed in permanent or semi-permanent storage.
 * @property defaultExpirationDays The default number of days until the data within the domain expires.
 * The following arguments are optional:
 * @property domainName The name for your Customer Profile domain. It must be unique for your AWS account.
 * @property matching A block that specifies the process of matching duplicate profiles. Documented below.
 * @property ruleBasedMatching A block that specifies the process of matching duplicate profiles using the Rule-Based matching. Documented below.
 * @property tags Tags to apply to the domain. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * */*/*/*/*/*/
 */
public data class DomainArgs(
    public val deadLetterQueueUrl: Output<String>? = null,
    public val defaultEncryptionKey: Output<String>? = null,
    public val defaultExpirationDays: Output<Int>? = null,
    public val domainName: Output<String>? = null,
    public val matching: Output<DomainMatchingArgs>? = null,
    public val ruleBasedMatching: Output<DomainRuleBasedMatchingArgs>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.customerprofiles.DomainArgs> {
    override fun toJava(): com.pulumi.aws.customerprofiles.DomainArgs =
        com.pulumi.aws.customerprofiles.DomainArgs.builder()
            .deadLetterQueueUrl(deadLetterQueueUrl?.applyValue({ args0 -> args0 }))
            .defaultEncryptionKey(defaultEncryptionKey?.applyValue({ args0 -> args0 }))
            .defaultExpirationDays(defaultExpirationDays?.applyValue({ args0 -> args0 }))
            .domainName(domainName?.applyValue({ args0 -> args0 }))
            .matching(matching?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .ruleBasedMatching(ruleBasedMatching?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [DomainArgs].
 */
@PulumiTagMarker
public class DomainArgsBuilder internal constructor() {
    private var deadLetterQueueUrl: Output<String>? = null

    private var defaultEncryptionKey: Output<String>? = null

    private var defaultExpirationDays: Output<Int>? = null

    private var domainName: Output<String>? = null

    private var matching: Output<DomainMatchingArgs>? = null

    private var ruleBasedMatching: Output<DomainRuleBasedMatchingArgs>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The URL of the SQS dead letter queue, which is used for reporting errors associated with ingesting data from third party applications.
     */
    @JvmName("asynlvpauclakdrf")
    public suspend fun deadLetterQueueUrl(`value`: Output<String>) {
        this.deadLetterQueueUrl = value
    }

    /**
     * @param value The default encryption key, which is an AWS managed key, is used when no specific type of encryption key is specified. It is used to encrypt all data before it is placed in permanent or semi-permanent storage.
     */
    @JvmName("mstdxqnkpranwkmu")
    public suspend fun defaultEncryptionKey(`value`: Output<String>) {
        this.defaultEncryptionKey = value
    }

    /**
     * @param value The default number of days until the data within the domain expires.
     * The following arguments are optional:
     */
    @JvmName("rwmmerkkcnfpbwmw")
    public suspend fun defaultExpirationDays(`value`: Output<Int>) {
        this.defaultExpirationDays = value
    }

    /**
     * @param value The name for your Customer Profile domain. It must be unique for your AWS account.
     */
    @JvmName("vimsrefhhdixepgw")
    public suspend fun domainName(`value`: Output<String>) {
        this.domainName = value
    }

    /**
     * @param value A block that specifies the process of matching duplicate profiles. Documented below.
     */
    @JvmName("vyomoegpikhypgkm")
    public suspend fun matching(`value`: Output<DomainMatchingArgs>) {
        this.matching = value
    }

    /**
     * @param value A block that specifies the process of matching duplicate profiles using the Rule-Based matching. Documented below.
     */
    @JvmName("jnvjqgmsovmdoopv")
    public suspend fun ruleBasedMatching(`value`: Output<DomainRuleBasedMatchingArgs>) {
        this.ruleBasedMatching = value
    }

    /**
     * @param value Tags to apply to the domain. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("vjptpicfduywrxqt")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The URL of the SQS dead letter queue, which is used for reporting errors associated with ingesting data from third party applications.
     */
    @JvmName("dwisqwrbjxxomnmr")
    public suspend fun deadLetterQueueUrl(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deadLetterQueueUrl = mapped
    }

    /**
     * @param value The default encryption key, which is an AWS managed key, is used when no specific type of encryption key is specified. It is used to encrypt all data before it is placed in permanent or semi-permanent storage.
     */
    @JvmName("srggijrcgqdytena")
    public suspend fun defaultEncryptionKey(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.defaultEncryptionKey = mapped
    }

    /**
     * @param value The default number of days until the data within the domain expires.
     * The following arguments are optional:
     */
    @JvmName("ksdvqiysmgapwoev")
    public suspend fun defaultExpirationDays(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.defaultExpirationDays = mapped
    }

    /**
     * @param value The name for your Customer Profile domain. It must be unique for your AWS account.
     */
    @JvmName("mkqjnoopwhyjjtui")
    public suspend fun domainName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.domainName = mapped
    }

    /**
     * @param value A block that specifies the process of matching duplicate profiles. Documented below.
     */
    @JvmName("vujosuqgwwahesdw")
    public suspend fun matching(`value`: DomainMatchingArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.matching = mapped
    }

    /**
     * @param argument A block that specifies the process of matching duplicate profiles. Documented below.
     */
    @JvmName("foearhjmuhjissay")
    public suspend fun matching(argument: suspend DomainMatchingArgsBuilder.() -> Unit) {
        val toBeMapped = DomainMatchingArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.matching = mapped
    }

    /**
     * @param value A block that specifies the process of matching duplicate profiles using the Rule-Based matching. Documented below.
     */
    @JvmName("xcvqyyqctjxeoyux")
    public suspend fun ruleBasedMatching(`value`: DomainRuleBasedMatchingArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ruleBasedMatching = mapped
    }

    /**
     * @param argument A block that specifies the process of matching duplicate profiles using the Rule-Based matching. Documented below.
     */
    @JvmName("ykltacqpqjyptebu")
    public suspend fun ruleBasedMatching(argument: suspend DomainRuleBasedMatchingArgsBuilder.() -> Unit) {
        val toBeMapped = DomainRuleBasedMatchingArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.ruleBasedMatching = mapped
    }

    /**
     * @param value Tags to apply to the domain. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("umpiuamwprgnqgeq")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Tags to apply to the domain. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("ugttuogteocxyknf")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): DomainArgs = DomainArgs(
        deadLetterQueueUrl = deadLetterQueueUrl,
        defaultEncryptionKey = defaultEncryptionKey,
        defaultExpirationDays = defaultExpirationDays,
        domainName = domainName,
        matching = matching,
        ruleBasedMatching = ruleBasedMatching,
        tags = tags,
    )
}
