@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.customerprofiles.kotlin

import com.pulumi.aws.customerprofiles.kotlin.outputs.ProfileAddress
import com.pulumi.aws.customerprofiles.kotlin.outputs.ProfileBillingAddress
import com.pulumi.aws.customerprofiles.kotlin.outputs.ProfileMailingAddress
import com.pulumi.aws.customerprofiles.kotlin.outputs.ProfileShippingAddress
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.aws.customerprofiles.kotlin.outputs.ProfileAddress.Companion.toKotlin as profileAddressToKotlin
import com.pulumi.aws.customerprofiles.kotlin.outputs.ProfileBillingAddress.Companion.toKotlin as profileBillingAddressToKotlin
import com.pulumi.aws.customerprofiles.kotlin.outputs.ProfileMailingAddress.Companion.toKotlin as profileMailingAddressToKotlin
import com.pulumi.aws.customerprofiles.kotlin.outputs.ProfileShippingAddress.Companion.toKotlin as profileShippingAddressToKotlin

/**
 * Builder for [Profile].
 */
@PulumiTagMarker
public class ProfileResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ProfileArgs = ProfileArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ProfileArgsBuilder.() -> Unit) {
        val builder = ProfileArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Profile {
        val builtJavaResource = com.pulumi.aws.customerprofiles.Profile(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Profile(builtJavaResource)
    }
}

/**
 * Resource for managing an Amazon Customer Profiles Profile.
 * See the [Create Profile](https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_CreateProfile.html) for more information.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.customerprofiles.Domain("example", {domainName: "example"});
 * const exampleProfile = new aws.customerprofiles.Profile("example", {domainName: example.domainName});
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.customerprofiles.Domain("example", domain_name="example")
 * example_profile = aws.customerprofiles.Profile("example", domain_name=example.domain_name)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.CustomerProfiles.Domain("example", new()
 *     {
 *         DomainName = "example",
 *     });
 *     var exampleProfile = new Aws.CustomerProfiles.Profile("example", new()
 *     {
 *         DomainName = example.DomainName,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/customerprofiles"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		example, err := customerprofiles.NewDomain(ctx, "example", &customerprofiles.DomainArgs{
 * 			DomainName: pulumi.String("example"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = customerprofiles.NewProfile(ctx, "example", &customerprofiles.ProfileArgs{
 * 			DomainName: example.DomainName,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.customerprofiles.Domain;
 * import com.pulumi.aws.customerprofiles.DomainArgs;
 * import com.pulumi.aws.customerprofiles.Profile;
 * import com.pulumi.aws.customerprofiles.ProfileArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Domain("example", DomainArgs.builder()
 *             .domainName("example")
 *             .build());
 *         var exampleProfile = new Profile("exampleProfile", ProfileArgs.builder()
 *             .domainName(example.domainName())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:customerprofiles:Domain
 *     properties:
 *       domainName: example
 *   exampleProfile:
 *     type: aws:customerprofiles:Profile
 *     name: example
 *     properties:
 *       domainName: ${example.domainName}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Amazon Customer Profiles Profile using the resource `id`. For example:
 * ```sh
 * $ pulumi import aws:customerprofiles/profile:Profile example domain-name/5f2f473dfbe841eb8d05cfc2a4c926df
 * ```
 */
public class Profile internal constructor(
    override val javaResource: com.pulumi.aws.customerprofiles.Profile,
) : KotlinCustomResource(javaResource, ProfileMapper) {
    /**
     * A unique account number that you have given to the customer.
     */
    public val accountNumber: Output<String>?
        get() = javaResource.accountNumber().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Any additional information relevant to the customer’s profile.
     */
    public val additionalInformation: Output<String>?
        get() = javaResource.additionalInformation().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * A block that specifies a generic address associated with the customer that is not mailing, shipping, or billing. Documented below.
     */
    public val address: Output<ProfileAddress>?
        get() = javaResource.address().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    profileAddressToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * A key value pair of attributes of a customer profile.
     */
    public val attributes: Output<Map<String, String>>?
        get() = javaResource.attributes().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A block that specifies the customer’s billing address. Documented below.
     */
    public val billingAddress: Output<ProfileBillingAddress>?
        get() = javaResource.billingAddress().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> profileBillingAddressToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * The customer’s birth date.
     */
    public val birthDate: Output<String>?
        get() = javaResource.birthDate().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The customer’s business email address.
     */
    public val businessEmailAddress: Output<String>?
        get() = javaResource.businessEmailAddress().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The name of the customer’s business.
     */
    public val businessName: Output<String>?
        get() = javaResource.businessName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The customer’s business phone number.
     */
    public val businessPhoneNumber: Output<String>?
        get() = javaResource.businessPhoneNumber().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The name of your Customer Profile domain. It must be unique for your AWS account.
     * The following arguments are optional:
     */
    public val domainName: Output<String>
        get() = javaResource.domainName().applyValue({ args0 -> args0 })

    /**
     * The customer’s email address, which has not been specified as a personal or business address.
     */
    public val emailAddress: Output<String>?
        get() = javaResource.emailAddress().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The customer’s first name.
     */
    public val firstName: Output<String>?
        get() = javaResource.firstName().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The gender with which the customer identifies.
     */
    public val genderString: Output<String>?
        get() = javaResource.genderString().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The customer’s home phone number.
     */
    public val homePhoneNumber: Output<String>?
        get() = javaResource.homePhoneNumber().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The customer’s last name.
     */
    public val lastName: Output<String>?
        get() = javaResource.lastName().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * A block that specifies the customer’s mailing address. Documented below.
     */
    public val mailingAddress: Output<ProfileMailingAddress>?
        get() = javaResource.mailingAddress().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> profileMailingAddressToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * The customer’s middle name.
     */
    public val middleName: Output<String>?
        get() = javaResource.middleName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The customer’s mobile phone number.
     */
    public val mobilePhoneNumber: Output<String>?
        get() = javaResource.mobilePhoneNumber().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The type of profile used to describe the customer.
     */
    public val partyTypeString: Output<String>?
        get() = javaResource.partyTypeString().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The customer’s personal email address.
     */
    public val personalEmailAddress: Output<String>?
        get() = javaResource.personalEmailAddress().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The customer’s phone number, which has not been specified as a mobile, home, or business number.
     */
    public val phoneNumber: Output<String>?
        get() = javaResource.phoneNumber().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * A block that specifies the customer’s shipping address. Documented below.
     */
    public val shippingAddress: Output<ProfileShippingAddress>?
        get() = javaResource.shippingAddress().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> profileShippingAddressToKotlin(args0) })
            }).orElse(null)
        })
}

public object ProfileMapper : ResourceMapper<Profile> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.customerprofiles.Profile::class == javaResource::class

    override fun map(javaResource: Resource): Profile = Profile(
        javaResource as
            com.pulumi.aws.customerprofiles.Profile,
    )
}

/**
 * @see [Profile].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Profile].
 */
public suspend fun profile(name: String, block: suspend ProfileResourceBuilder.() -> Unit): Profile {
    val builder = ProfileResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Profile].
 * @param name The _unique_ name of the resulting resource.
 */
public fun profile(name: String): Profile {
    val builder = ProfileResourceBuilder()
    builder.name(name)
    return builder.build()
}
