@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.customerprofiles.kotlin

import com.pulumi.aws.customerprofiles.ProfileArgs.builder
import com.pulumi.aws.customerprofiles.kotlin.inputs.ProfileAddressArgs
import com.pulumi.aws.customerprofiles.kotlin.inputs.ProfileAddressArgsBuilder
import com.pulumi.aws.customerprofiles.kotlin.inputs.ProfileBillingAddressArgs
import com.pulumi.aws.customerprofiles.kotlin.inputs.ProfileBillingAddressArgsBuilder
import com.pulumi.aws.customerprofiles.kotlin.inputs.ProfileMailingAddressArgs
import com.pulumi.aws.customerprofiles.kotlin.inputs.ProfileMailingAddressArgsBuilder
import com.pulumi.aws.customerprofiles.kotlin.inputs.ProfileShippingAddressArgs
import com.pulumi.aws.customerprofiles.kotlin.inputs.ProfileShippingAddressArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Resource for managing an Amazon Customer Profiles Profile.
 * See the [Create Profile](https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_CreateProfile.html) for more information.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.customerprofiles.Domain("example", {domainName: "example"});
 * const exampleProfile = new aws.customerprofiles.Profile("example", {domainName: example.domainName});
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.customerprofiles.Domain("example", domain_name="example")
 * example_profile = aws.customerprofiles.Profile("example", domain_name=example.domain_name)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.CustomerProfiles.Domain("example", new()
 *     {
 *         DomainName = "example",
 *     });
 *     var exampleProfile = new Aws.CustomerProfiles.Profile("example", new()
 *     {
 *         DomainName = example.DomainName,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/customerprofiles"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		example, err := customerprofiles.NewDomain(ctx, "example", &customerprofiles.DomainArgs{
 * 			DomainName: pulumi.String("example"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = customerprofiles.NewProfile(ctx, "example", &customerprofiles.ProfileArgs{
 * 			DomainName: example.DomainName,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.customerprofiles.Domain;
 * import com.pulumi.aws.customerprofiles.DomainArgs;
 * import com.pulumi.aws.customerprofiles.Profile;
 * import com.pulumi.aws.customerprofiles.ProfileArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Domain("example", DomainArgs.builder()
 *             .domainName("example")
 *             .build());
 *         var exampleProfile = new Profile("exampleProfile", ProfileArgs.builder()
 *             .domainName(example.domainName())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:customerprofiles:Domain
 *     properties:
 *       domainName: example
 *   exampleProfile:
 *     type: aws:customerprofiles:Profile
 *     name: example
 *     properties:
 *       domainName: ${example.domainName}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Amazon Customer Profiles Profile using the resource `id`. For example:
 * ```sh
 * $ pulumi import aws:customerprofiles/profile:Profile example domain-name/5f2f473dfbe841eb8d05cfc2a4c926df
 * ```
 * @property accountNumber A unique account number that you have given to the customer.
 * @property additionalInformation Any additional information relevant to the customer’s profile.
 * @property address A block that specifies a generic address associated with the customer that is not mailing, shipping, or billing. Documented below.
 * @property attributes A key value pair of attributes of a customer profile.
 * @property billingAddress A block that specifies the customer’s billing address. Documented below.
 * @property birthDate The customer’s birth date.
 * @property businessEmailAddress The customer’s business email address.
 * @property businessName The name of the customer’s business.
 * @property businessPhoneNumber The customer’s business phone number.
 * @property domainName The name of your Customer Profile domain. It must be unique for your AWS account.
 * The following arguments are optional:
 * @property emailAddress The customer’s email address, which has not been specified as a personal or business address.
 * @property firstName The customer’s first name.
 * @property genderString The gender with which the customer identifies.
 * @property homePhoneNumber The customer’s home phone number.
 * @property lastName The customer’s last name.
 * @property mailingAddress A block that specifies the customer’s mailing address. Documented below.
 * @property middleName The customer’s middle name.
 * @property mobilePhoneNumber The customer’s mobile phone number.
 * @property partyTypeString The type of profile used to describe the customer.
 * @property personalEmailAddress The customer’s personal email address.
 * @property phoneNumber The customer’s phone number, which has not been specified as a mobile, home, or business number.
 * @property shippingAddress A block that specifies the customer’s shipping address. Documented below.
 */
public data class ProfileArgs(
    public val accountNumber: Output<String>? = null,
    public val additionalInformation: Output<String>? = null,
    public val address: Output<ProfileAddressArgs>? = null,
    public val attributes: Output<Map<String, String>>? = null,
    public val billingAddress: Output<ProfileBillingAddressArgs>? = null,
    public val birthDate: Output<String>? = null,
    public val businessEmailAddress: Output<String>? = null,
    public val businessName: Output<String>? = null,
    public val businessPhoneNumber: Output<String>? = null,
    public val domainName: Output<String>? = null,
    public val emailAddress: Output<String>? = null,
    public val firstName: Output<String>? = null,
    public val genderString: Output<String>? = null,
    public val homePhoneNumber: Output<String>? = null,
    public val lastName: Output<String>? = null,
    public val mailingAddress: Output<ProfileMailingAddressArgs>? = null,
    public val middleName: Output<String>? = null,
    public val mobilePhoneNumber: Output<String>? = null,
    public val partyTypeString: Output<String>? = null,
    public val personalEmailAddress: Output<String>? = null,
    public val phoneNumber: Output<String>? = null,
    public val shippingAddress: Output<ProfileShippingAddressArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.customerprofiles.ProfileArgs> {
    override fun toJava(): com.pulumi.aws.customerprofiles.ProfileArgs =
        com.pulumi.aws.customerprofiles.ProfileArgs.builder()
            .accountNumber(accountNumber?.applyValue({ args0 -> args0 }))
            .additionalInformation(additionalInformation?.applyValue({ args0 -> args0 }))
            .address(address?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .attributes(
                attributes?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .billingAddress(billingAddress?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .birthDate(birthDate?.applyValue({ args0 -> args0 }))
            .businessEmailAddress(businessEmailAddress?.applyValue({ args0 -> args0 }))
            .businessName(businessName?.applyValue({ args0 -> args0 }))
            .businessPhoneNumber(businessPhoneNumber?.applyValue({ args0 -> args0 }))
            .domainName(domainName?.applyValue({ args0 -> args0 }))
            .emailAddress(emailAddress?.applyValue({ args0 -> args0 }))
            .firstName(firstName?.applyValue({ args0 -> args0 }))
            .genderString(genderString?.applyValue({ args0 -> args0 }))
            .homePhoneNumber(homePhoneNumber?.applyValue({ args0 -> args0 }))
            .lastName(lastName?.applyValue({ args0 -> args0 }))
            .mailingAddress(mailingAddress?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .middleName(middleName?.applyValue({ args0 -> args0 }))
            .mobilePhoneNumber(mobilePhoneNumber?.applyValue({ args0 -> args0 }))
            .partyTypeString(partyTypeString?.applyValue({ args0 -> args0 }))
            .personalEmailAddress(personalEmailAddress?.applyValue({ args0 -> args0 }))
            .phoneNumber(phoneNumber?.applyValue({ args0 -> args0 }))
            .shippingAddress(
                shippingAddress?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [ProfileArgs].
 */
@PulumiTagMarker
public class ProfileArgsBuilder internal constructor() {
    private var accountNumber: Output<String>? = null

    private var additionalInformation: Output<String>? = null

    private var address: Output<ProfileAddressArgs>? = null

    private var attributes: Output<Map<String, String>>? = null

    private var billingAddress: Output<ProfileBillingAddressArgs>? = null

    private var birthDate: Output<String>? = null

    private var businessEmailAddress: Output<String>? = null

    private var businessName: Output<String>? = null

    private var businessPhoneNumber: Output<String>? = null

    private var domainName: Output<String>? = null

    private var emailAddress: Output<String>? = null

    private var firstName: Output<String>? = null

    private var genderString: Output<String>? = null

    private var homePhoneNumber: Output<String>? = null

    private var lastName: Output<String>? = null

    private var mailingAddress: Output<ProfileMailingAddressArgs>? = null

    private var middleName: Output<String>? = null

    private var mobilePhoneNumber: Output<String>? = null

    private var partyTypeString: Output<String>? = null

    private var personalEmailAddress: Output<String>? = null

    private var phoneNumber: Output<String>? = null

    private var shippingAddress: Output<ProfileShippingAddressArgs>? = null

    /**
     * @param value A unique account number that you have given to the customer.
     */
    @JvmName("puojiubsghjojwum")
    public suspend fun accountNumber(`value`: Output<String>) {
        this.accountNumber = value
    }

    /**
     * @param value Any additional information relevant to the customer’s profile.
     */
    @JvmName("yxslwlswjtklvfts")
    public suspend fun additionalInformation(`value`: Output<String>) {
        this.additionalInformation = value
    }

    /**
     * @param value A block that specifies a generic address associated with the customer that is not mailing, shipping, or billing. Documented below.
     */
    @JvmName("uohekwxvabdwsnsw")
    public suspend fun address(`value`: Output<ProfileAddressArgs>) {
        this.address = value
    }

    /**
     * @param value A key value pair of attributes of a customer profile.
     */
    @JvmName("qpdijckingqqffmn")
    public suspend fun attributes(`value`: Output<Map<String, String>>) {
        this.attributes = value
    }

    /**
     * @param value A block that specifies the customer’s billing address. Documented below.
     */
    @JvmName("gfayogpdxrmueyrp")
    public suspend fun billingAddress(`value`: Output<ProfileBillingAddressArgs>) {
        this.billingAddress = value
    }

    /**
     * @param value The customer’s birth date.
     */
    @JvmName("hmanibdyqoibalee")
    public suspend fun birthDate(`value`: Output<String>) {
        this.birthDate = value
    }

    /**
     * @param value The customer’s business email address.
     */
    @JvmName("sfmusviesjgfxvpe")
    public suspend fun businessEmailAddress(`value`: Output<String>) {
        this.businessEmailAddress = value
    }

    /**
     * @param value The name of the customer’s business.
     */
    @JvmName("wxsybcshajlgkpyy")
    public suspend fun businessName(`value`: Output<String>) {
        this.businessName = value
    }

    /**
     * @param value The customer’s business phone number.
     */
    @JvmName("xtbversqqjkhmdcc")
    public suspend fun businessPhoneNumber(`value`: Output<String>) {
        this.businessPhoneNumber = value
    }

    /**
     * @param value The name of your Customer Profile domain. It must be unique for your AWS account.
     * The following arguments are optional:
     */
    @JvmName("otcppvprkbvbcnww")
    public suspend fun domainName(`value`: Output<String>) {
        this.domainName = value
    }

    /**
     * @param value The customer’s email address, which has not been specified as a personal or business address.
     */
    @JvmName("seobmevoyecomelk")
    public suspend fun emailAddress(`value`: Output<String>) {
        this.emailAddress = value
    }

    /**
     * @param value The customer’s first name.
     */
    @JvmName("txfypbuctvobqpbm")
    public suspend fun firstName(`value`: Output<String>) {
        this.firstName = value
    }

    /**
     * @param value The gender with which the customer identifies.
     */
    @JvmName("cbeqeyksymhpocqs")
    public suspend fun genderString(`value`: Output<String>) {
        this.genderString = value
    }

    /**
     * @param value The customer’s home phone number.
     */
    @JvmName("aqpnntqpvltihxsm")
    public suspend fun homePhoneNumber(`value`: Output<String>) {
        this.homePhoneNumber = value
    }

    /**
     * @param value The customer’s last name.
     */
    @JvmName("rfdpqjqdxxuecnca")
    public suspend fun lastName(`value`: Output<String>) {
        this.lastName = value
    }

    /**
     * @param value A block that specifies the customer’s mailing address. Documented below.
     */
    @JvmName("jssvmnegkqwbjtll")
    public suspend fun mailingAddress(`value`: Output<ProfileMailingAddressArgs>) {
        this.mailingAddress = value
    }

    /**
     * @param value The customer’s middle name.
     */
    @JvmName("kyjwurebckprjlsi")
    public suspend fun middleName(`value`: Output<String>) {
        this.middleName = value
    }

    /**
     * @param value The customer’s mobile phone number.
     */
    @JvmName("gcgftvaimfvnslrn")
    public suspend fun mobilePhoneNumber(`value`: Output<String>) {
        this.mobilePhoneNumber = value
    }

    /**
     * @param value The type of profile used to describe the customer.
     */
    @JvmName("cwajjppkxqeuytyh")
    public suspend fun partyTypeString(`value`: Output<String>) {
        this.partyTypeString = value
    }

    /**
     * @param value The customer’s personal email address.
     */
    @JvmName("fgbdxqvfefusdkdm")
    public suspend fun personalEmailAddress(`value`: Output<String>) {
        this.personalEmailAddress = value
    }

    /**
     * @param value The customer’s phone number, which has not been specified as a mobile, home, or business number.
     */
    @JvmName("jqlsvwxkdtwrvmqq")
    public suspend fun phoneNumber(`value`: Output<String>) {
        this.phoneNumber = value
    }

    /**
     * @param value A block that specifies the customer’s shipping address. Documented below.
     */
    @JvmName("ricpxyyvcmckrepm")
    public suspend fun shippingAddress(`value`: Output<ProfileShippingAddressArgs>) {
        this.shippingAddress = value
    }

    /**
     * @param value A unique account number that you have given to the customer.
     */
    @JvmName("bvhmgsdrupvcoprj")
    public suspend fun accountNumber(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accountNumber = mapped
    }

    /**
     * @param value Any additional information relevant to the customer’s profile.
     */
    @JvmName("cjhvkyiyduowqeqp")
    public suspend fun additionalInformation(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.additionalInformation = mapped
    }

    /**
     * @param value A block that specifies a generic address associated with the customer that is not mailing, shipping, or billing. Documented below.
     */
    @JvmName("sfyogxrhbwmnknwu")
    public suspend fun address(`value`: ProfileAddressArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.address = mapped
    }

    /**
     * @param argument A block that specifies a generic address associated with the customer that is not mailing, shipping, or billing. Documented below.
     */
    @JvmName("nkinlctbrfvgmdtp")
    public suspend fun address(argument: suspend ProfileAddressArgsBuilder.() -> Unit) {
        val toBeMapped = ProfileAddressArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.address = mapped
    }

    /**
     * @param value A key value pair of attributes of a customer profile.
     */
    @JvmName("wwmkgccmvltrfhxk")
    public suspend fun attributes(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.attributes = mapped
    }

    /**
     * @param values A key value pair of attributes of a customer profile.
     */
    @JvmName("axxdmqomoneegirh")
    public fun attributes(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.attributes = mapped
    }

    /**
     * @param value A block that specifies the customer’s billing address. Documented below.
     */
    @JvmName("dpiykkmskifwxxik")
    public suspend fun billingAddress(`value`: ProfileBillingAddressArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.billingAddress = mapped
    }

    /**
     * @param argument A block that specifies the customer’s billing address. Documented below.
     */
    @JvmName("xxxqcccfyaowohex")
    public suspend fun billingAddress(argument: suspend ProfileBillingAddressArgsBuilder.() -> Unit) {
        val toBeMapped = ProfileBillingAddressArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.billingAddress = mapped
    }

    /**
     * @param value The customer’s birth date.
     */
    @JvmName("lfnagoivuvnijvet")
    public suspend fun birthDate(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.birthDate = mapped
    }

    /**
     * @param value The customer’s business email address.
     */
    @JvmName("nmjuygjfanyrpbnu")
    public suspend fun businessEmailAddress(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.businessEmailAddress = mapped
    }

    /**
     * @param value The name of the customer’s business.
     */
    @JvmName("stynrmcwcmqjxqmk")
    public suspend fun businessName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.businessName = mapped
    }

    /**
     * @param value The customer’s business phone number.
     */
    @JvmName("nxtwmmilpcdbaomg")
    public suspend fun businessPhoneNumber(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.businessPhoneNumber = mapped
    }

    /**
     * @param value The name of your Customer Profile domain. It must be unique for your AWS account.
     * The following arguments are optional:
     */
    @JvmName("udnkmwpnfwewriqa")
    public suspend fun domainName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.domainName = mapped
    }

    /**
     * @param value The customer’s email address, which has not been specified as a personal or business address.
     */
    @JvmName("nvedvkehttuyqeqq")
    public suspend fun emailAddress(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.emailAddress = mapped
    }

    /**
     * @param value The customer’s first name.
     */
    @JvmName("ucdpuqttqnirdcgo")
    public suspend fun firstName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.firstName = mapped
    }

    /**
     * @param value The gender with which the customer identifies.
     */
    @JvmName("dukajkagmrsabqom")
    public suspend fun genderString(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.genderString = mapped
    }

    /**
     * @param value The customer’s home phone number.
     */
    @JvmName("poxyhejbrqugieck")
    public suspend fun homePhoneNumber(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.homePhoneNumber = mapped
    }

    /**
     * @param value The customer’s last name.
     */
    @JvmName("ykisllvpudxheynp")
    public suspend fun lastName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.lastName = mapped
    }

    /**
     * @param value A block that specifies the customer’s mailing address. Documented below.
     */
    @JvmName("rcrnqjmoqbchlpdo")
    public suspend fun mailingAddress(`value`: ProfileMailingAddressArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.mailingAddress = mapped
    }

    /**
     * @param argument A block that specifies the customer’s mailing address. Documented below.
     */
    @JvmName("fvoqtqrvofcsnnnj")
    public suspend fun mailingAddress(argument: suspend ProfileMailingAddressArgsBuilder.() -> Unit) {
        val toBeMapped = ProfileMailingAddressArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.mailingAddress = mapped
    }

    /**
     * @param value The customer’s middle name.
     */
    @JvmName("vhdjanvrjgvjugnw")
    public suspend fun middleName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.middleName = mapped
    }

    /**
     * @param value The customer’s mobile phone number.
     */
    @JvmName("xhhkuqrqwmkimqkv")
    public suspend fun mobilePhoneNumber(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.mobilePhoneNumber = mapped
    }

    /**
     * @param value The type of profile used to describe the customer.
     */
    @JvmName("vuvoaqwebkbasasu")
    public suspend fun partyTypeString(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.partyTypeString = mapped
    }

    /**
     * @param value The customer’s personal email address.
     */
    @JvmName("tbchroqcbdhnxvdc")
    public suspend fun personalEmailAddress(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.personalEmailAddress = mapped
    }

    /**
     * @param value The customer’s phone number, which has not been specified as a mobile, home, or business number.
     */
    @JvmName("xqabwjmldhxweeij")
    public suspend fun phoneNumber(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.phoneNumber = mapped
    }

    /**
     * @param value A block that specifies the customer’s shipping address. Documented below.
     */
    @JvmName("paymvjdergsyguit")
    public suspend fun shippingAddress(`value`: ProfileShippingAddressArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.shippingAddress = mapped
    }

    /**
     * @param argument A block that specifies the customer’s shipping address. Documented below.
     */
    @JvmName("wyupkbbkqwgcdrrp")
    public suspend fun shippingAddress(argument: suspend ProfileShippingAddressArgsBuilder.() -> Unit) {
        val toBeMapped = ProfileShippingAddressArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.shippingAddress = mapped
    }

    internal fun build(): ProfileArgs = ProfileArgs(
        accountNumber = accountNumber,
        additionalInformation = additionalInformation,
        address = address,
        attributes = attributes,
        billingAddress = billingAddress,
        birthDate = birthDate,
        businessEmailAddress = businessEmailAddress,
        businessName = businessName,
        businessPhoneNumber = businessPhoneNumber,
        domainName = domainName,
        emailAddress = emailAddress,
        firstName = firstName,
        genderString = genderString,
        homePhoneNumber = homePhoneNumber,
        lastName = lastName,
        mailingAddress = mailingAddress,
        middleName = middleName,
        mobilePhoneNumber = mobilePhoneNumber,
        partyTypeString = partyTypeString,
        personalEmailAddress = personalEmailAddress,
        phoneNumber = phoneNumber,
        shippingAddress = shippingAddress,
    )
}
