@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.customerprofiles.kotlin.inputs

import com.pulumi.aws.customerprofiles.inputs.DomainMatchingArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property autoMerging A block that specifies the configuration about the auto-merging process. Documented below.
 * @property enabled The flag that enables the matching process of duplicate profiles.
 * @property exportingConfig A block that specifies the configuration for exporting Identity Resolution results. Documented below.
 * @property jobSchedule A block that specifies the day and time when you want to start the Identity Resolution Job every week. Documented below.
 */
public data class DomainMatchingArgs(
    public val autoMerging: Output<DomainMatchingAutoMergingArgs>? = null,
    public val enabled: Output<Boolean>,
    public val exportingConfig: Output<DomainMatchingExportingConfigArgs>? = null,
    public val jobSchedule: Output<DomainMatchingJobScheduleArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.customerprofiles.inputs.DomainMatchingArgs> {
    override fun toJava(): com.pulumi.aws.customerprofiles.inputs.DomainMatchingArgs =
        com.pulumi.aws.customerprofiles.inputs.DomainMatchingArgs.builder()
            .autoMerging(autoMerging?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .enabled(enabled.applyValue({ args0 -> args0 }))
            .exportingConfig(exportingConfig?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .jobSchedule(jobSchedule?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [DomainMatchingArgs].
 */
@PulumiTagMarker
public class DomainMatchingArgsBuilder internal constructor() {
    private var autoMerging: Output<DomainMatchingAutoMergingArgs>? = null

    private var enabled: Output<Boolean>? = null

    private var exportingConfig: Output<DomainMatchingExportingConfigArgs>? = null

    private var jobSchedule: Output<DomainMatchingJobScheduleArgs>? = null

    /**
     * @param value A block that specifies the configuration about the auto-merging process. Documented below.
     */
    @JvmName("mhambifgbfgtqhqq")
    public suspend fun autoMerging(`value`: Output<DomainMatchingAutoMergingArgs>) {
        this.autoMerging = value
    }

    /**
     * @param value The flag that enables the matching process of duplicate profiles.
     */
    @JvmName("xtcmvnvtqsapcnkk")
    public suspend fun enabled(`value`: Output<Boolean>) {
        this.enabled = value
    }

    /**
     * @param value A block that specifies the configuration for exporting Identity Resolution results. Documented below.
     */
    @JvmName("ycchnthvotxrsgee")
    public suspend fun exportingConfig(`value`: Output<DomainMatchingExportingConfigArgs>) {
        this.exportingConfig = value
    }

    /**
     * @param value A block that specifies the day and time when you want to start the Identity Resolution Job every week. Documented below.
     */
    @JvmName("sgclvbmujfpktxoo")
    public suspend fun jobSchedule(`value`: Output<DomainMatchingJobScheduleArgs>) {
        this.jobSchedule = value
    }

    /**
     * @param value A block that specifies the configuration about the auto-merging process. Documented below.
     */
    @JvmName("pffneogcmnedigdn")
    public suspend fun autoMerging(`value`: DomainMatchingAutoMergingArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.autoMerging = mapped
    }

    /**
     * @param argument A block that specifies the configuration about the auto-merging process. Documented below.
     */
    @JvmName("xpidtkxtvgmhsvmb")
    public suspend fun autoMerging(argument: suspend DomainMatchingAutoMergingArgsBuilder.() -> Unit) {
        val toBeMapped = DomainMatchingAutoMergingArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.autoMerging = mapped
    }

    /**
     * @param value The flag that enables the matching process of duplicate profiles.
     */
    @JvmName("vodkqierwbmrvlpi")
    public suspend fun enabled(`value`: Boolean) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.enabled = mapped
    }

    /**
     * @param value A block that specifies the configuration for exporting Identity Resolution results. Documented below.
     */
    @JvmName("kifqpkbgmntttjuc")
    public suspend fun exportingConfig(`value`: DomainMatchingExportingConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.exportingConfig = mapped
    }

    /**
     * @param argument A block that specifies the configuration for exporting Identity Resolution results. Documented below.
     */
    @JvmName("punvrwnjjlclpigp")
    public suspend fun exportingConfig(argument: suspend DomainMatchingExportingConfigArgsBuilder.() -> Unit) {
        val toBeMapped = DomainMatchingExportingConfigArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.exportingConfig = mapped
    }

    /**
     * @param value A block that specifies the day and time when you want to start the Identity Resolution Job every week. Documented below.
     */
    @JvmName("cjusdwdxoxetkhmd")
    public suspend fun jobSchedule(`value`: DomainMatchingJobScheduleArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.jobSchedule = mapped
    }

    /**
     * @param argument A block that specifies the day and time when you want to start the Identity Resolution Job every week. Documented below.
     */
    @JvmName("duabbdyklwcskkvt")
    public suspend fun jobSchedule(argument: suspend DomainMatchingJobScheduleArgsBuilder.() -> Unit) {
        val toBeMapped = DomainMatchingJobScheduleArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.jobSchedule = mapped
    }

    internal fun build(): DomainMatchingArgs = DomainMatchingArgs(
        autoMerging = autoMerging,
        enabled = enabled ?: throw PulumiNullFieldException("enabled"),
        exportingConfig = exportingConfig,
        jobSchedule = jobSchedule,
    )
}
