@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.customerprofiles.kotlin.inputs

import com.pulumi.aws.customerprofiles.inputs.DomainMatchingAutoMergingArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Double
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property conflictResolution A block that specifies how the auto-merging process should resolve conflicts between different profiles. Documented below.
 * @property consolidation A block that specifies a list of matching attributes that represent matching criteria. If two profiles meet at least one of the requirements in the matching attributes list, they will be merged. Documented below.
 * * `min_allowed_confidence_score_for_merging ` - (Optional) A number between 0 and 1 that represents the minimum confidence score required for profiles within a matching group to be merged during the auto-merge process. A higher score means higher similarity required to merge profiles.
 * @property enabled The flag that enables the auto-merging of duplicate profiles.
 * @property minAllowedConfidenceScoreForMerging
 */
public data class DomainMatchingAutoMergingArgs(
    public val conflictResolution: Output<DomainMatchingAutoMergingConflictResolutionArgs>? = null,
    public val consolidation: Output<DomainMatchingAutoMergingConsolidationArgs>? = null,
    public val enabled: Output<Boolean>,
    public val minAllowedConfidenceScoreForMerging: Output<Double>? = null,
) : ConvertibleToJava<com.pulumi.aws.customerprofiles.inputs.DomainMatchingAutoMergingArgs> {
    override fun toJava(): com.pulumi.aws.customerprofiles.inputs.DomainMatchingAutoMergingArgs =
        com.pulumi.aws.customerprofiles.inputs.DomainMatchingAutoMergingArgs.builder()
            .conflictResolution(
                conflictResolution?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .consolidation(consolidation?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .enabled(enabled.applyValue({ args0 -> args0 }))
            .minAllowedConfidenceScoreForMerging(
                minAllowedConfidenceScoreForMerging?.applyValue({ args0 ->
                    args0
                }),
            ).build()
}

/**
 * Builder for [DomainMatchingAutoMergingArgs].
 */
@PulumiTagMarker
public class DomainMatchingAutoMergingArgsBuilder internal constructor() {
    private var conflictResolution: Output<DomainMatchingAutoMergingConflictResolutionArgs>? = null

    private var consolidation: Output<DomainMatchingAutoMergingConsolidationArgs>? = null

    private var enabled: Output<Boolean>? = null

    private var minAllowedConfidenceScoreForMerging: Output<Double>? = null

    /**
     * @param value A block that specifies how the auto-merging process should resolve conflicts between different profiles. Documented below.
     */
    @JvmName("sglpatpjtqmnfcye")
    public suspend fun conflictResolution(`value`: Output<DomainMatchingAutoMergingConflictResolutionArgs>) {
        this.conflictResolution = value
    }

    /**
     * @param value A block that specifies a list of matching attributes that represent matching criteria. If two profiles meet at least one of the requirements in the matching attributes list, they will be merged. Documented below.
     * * `min_allowed_confidence_score_for_merging ` - (Optional) A number between 0 and 1 that represents the minimum confidence score required for profiles within a matching group to be merged during the auto-merge process. A higher score means higher similarity required to merge profiles.
     */
    @JvmName("drybixtfiggyujmt")
    public suspend fun consolidation(`value`: Output<DomainMatchingAutoMergingConsolidationArgs>) {
        this.consolidation = value
    }

    /**
     * @param value The flag that enables the auto-merging of duplicate profiles.
     */
    @JvmName("huknwqyteigiabbl")
    public suspend fun enabled(`value`: Output<Boolean>) {
        this.enabled = value
    }

    /**
     * @param value
     */
    @JvmName("uhykjltwgkvthmnt")
    public suspend fun minAllowedConfidenceScoreForMerging(`value`: Output<Double>) {
        this.minAllowedConfidenceScoreForMerging = value
    }

    /**
     * @param value A block that specifies how the auto-merging process should resolve conflicts between different profiles. Documented below.
     */
    @JvmName("deprtkjqfqijomac")
    public suspend fun conflictResolution(`value`: DomainMatchingAutoMergingConflictResolutionArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.conflictResolution = mapped
    }

    /**
     * @param argument A block that specifies how the auto-merging process should resolve conflicts between different profiles. Documented below.
     */
    @JvmName("ovtosivawvpeqjld")
    public suspend fun conflictResolution(argument: suspend DomainMatchingAutoMergingConflictResolutionArgsBuilder.() -> Unit) {
        val toBeMapped = DomainMatchingAutoMergingConflictResolutionArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.conflictResolution = mapped
    }

    /**
     * @param value A block that specifies a list of matching attributes that represent matching criteria. If two profiles meet at least one of the requirements in the matching attributes list, they will be merged. Documented below.
     * * `min_allowed_confidence_score_for_merging ` - (Optional) A number between 0 and 1 that represents the minimum confidence score required for profiles within a matching group to be merged during the auto-merge process. A higher score means higher similarity required to merge profiles.
     */
    @JvmName("twfrjsfsnvmqgtml")
    public suspend fun consolidation(`value`: DomainMatchingAutoMergingConsolidationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.consolidation = mapped
    }

    /**
     * @param argument A block that specifies a list of matching attributes that represent matching criteria. If two profiles meet at least one of the requirements in the matching attributes list, they will be merged. Documented below.
     * * `min_allowed_confidence_score_for_merging ` - (Optional) A number between 0 and 1 that represents the minimum confidence score required for profiles within a matching group to be merged during the auto-merge process. A higher score means higher similarity required to merge profiles.
     */
    @JvmName("nrrcgpreehtytsfc")
    public suspend fun consolidation(argument: suspend DomainMatchingAutoMergingConsolidationArgsBuilder.() -> Unit) {
        val toBeMapped = DomainMatchingAutoMergingConsolidationArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.consolidation = mapped
    }

    /**
     * @param value The flag that enables the auto-merging of duplicate profiles.
     */
    @JvmName("cllmpwlsbtdrpsno")
    public suspend fun enabled(`value`: Boolean) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.enabled = mapped
    }

    /**
     * @param value
     */
    @JvmName("rpnnmnwuxymrcwhs")
    public suspend fun minAllowedConfidenceScoreForMerging(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.minAllowedConfidenceScoreForMerging = mapped
    }

    internal fun build(): DomainMatchingAutoMergingArgs = DomainMatchingAutoMergingArgs(
        conflictResolution = conflictResolution,
        consolidation = consolidation,
        enabled = enabled ?: throw PulumiNullFieldException("enabled"),
        minAllowedConfidenceScoreForMerging = minAllowedConfidenceScoreForMerging,
    )
}
