@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.customerprofiles.kotlin.inputs

import com.pulumi.aws.customerprofiles.inputs.DomainMatchingAutoMergingConsolidationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property matchingAttributesLists A list of matching criteria.
 */
public data class DomainMatchingAutoMergingConsolidationArgs(
    public val matchingAttributesLists: Output<List<List<String>>>,
) :
    ConvertibleToJava<com.pulumi.aws.customerprofiles.inputs.DomainMatchingAutoMergingConsolidationArgs> {
    override fun toJava(): com.pulumi.aws.customerprofiles.inputs.DomainMatchingAutoMergingConsolidationArgs =
        com.pulumi.aws.customerprofiles.inputs.DomainMatchingAutoMergingConsolidationArgs.builder()
            .matchingAttributesLists(
                matchingAttributesLists.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.map({ args0 -> args0 })
                    })
                }),
            ).build()
}

/**
 * Builder for [DomainMatchingAutoMergingConsolidationArgs].
 */
@PulumiTagMarker
public class DomainMatchingAutoMergingConsolidationArgsBuilder internal constructor() {
    private var matchingAttributesLists: Output<List<List<String>>>? = null

    /**
     * @param value A list of matching criteria.
     */
    @JvmName("jpwtkkunyinarqcp")
    public suspend fun matchingAttributesLists(`value`: Output<List<List<String>>>) {
        this.matchingAttributesLists = value
    }

    @JvmName("bqerkbdkskjnnjap")
    public suspend fun matchingAttributesLists(vararg values: Output<List<String>>) {
        this.matchingAttributesLists = Output.all(values.asList())
    }

    /**
     * @param values A list of matching criteria.
     */
    @JvmName("ausyktldttuwugbb")
    public suspend fun matchingAttributesLists(values: List<Output<List<String>>>) {
        this.matchingAttributesLists = Output.all(values)
    }

    /**
     * @param value A list of matching criteria.
     */
    @JvmName("ssfaklaxviodhqtj")
    public suspend fun matchingAttributesLists(`value`: List<List<String>>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.matchingAttributesLists = mapped
    }

    /**
     * @param values A list of matching criteria.
     */
    @JvmName("xtuwovurqelntlmx")
    public suspend fun matchingAttributesLists(vararg values: List<String>) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.matchingAttributesLists = mapped
    }

    internal fun build(): DomainMatchingAutoMergingConsolidationArgs =
        DomainMatchingAutoMergingConsolidationArgs(
            matchingAttributesLists = matchingAttributesLists ?: throw
                PulumiNullFieldException("matchingAttributesLists"),
        )
}
