@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.customerprofiles.kotlin.inputs

import com.pulumi.aws.customerprofiles.inputs.DomainMatchingExportingConfigS3ExportingArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property s3BucketName The name of the S3 bucket where Identity Resolution Jobs write result files.
 * @property s3KeyName The S3 key name of the location where Identity Resolution Jobs write result files.
 */
public data class DomainMatchingExportingConfigS3ExportingArgs(
    public val s3BucketName: Output<String>,
    public val s3KeyName: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.customerprofiles.inputs.DomainMatchingExportingConfigS3ExportingArgs> {
    override fun toJava(): com.pulumi.aws.customerprofiles.inputs.DomainMatchingExportingConfigS3ExportingArgs =
        com.pulumi.aws.customerprofiles.inputs.DomainMatchingExportingConfigS3ExportingArgs.builder()
            .s3BucketName(s3BucketName.applyValue({ args0 -> args0 }))
            .s3KeyName(s3KeyName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DomainMatchingExportingConfigS3ExportingArgs].
 */
@PulumiTagMarker
public class DomainMatchingExportingConfigS3ExportingArgsBuilder internal constructor() {
    private var s3BucketName: Output<String>? = null

    private var s3KeyName: Output<String>? = null

    /**
     * @param value The name of the S3 bucket where Identity Resolution Jobs write result files.
     */
    @JvmName("fflxabwlciqqwcpl")
    public suspend fun s3BucketName(`value`: Output<String>) {
        this.s3BucketName = value
    }

    /**
     * @param value The S3 key name of the location where Identity Resolution Jobs write result files.
     */
    @JvmName("xltdfxslkebmsgvk")
    public suspend fun s3KeyName(`value`: Output<String>) {
        this.s3KeyName = value
    }

    /**
     * @param value The name of the S3 bucket where Identity Resolution Jobs write result files.
     */
    @JvmName("ymbowxfqpoghbrxr")
    public suspend fun s3BucketName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.s3BucketName = mapped
    }

    /**
     * @param value The S3 key name of the location where Identity Resolution Jobs write result files.
     */
    @JvmName("gnfgncubqbgbsskx")
    public suspend fun s3KeyName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.s3KeyName = mapped
    }

    internal fun build(): DomainMatchingExportingConfigS3ExportingArgs =
        DomainMatchingExportingConfigS3ExportingArgs(
            s3BucketName = s3BucketName ?: throw PulumiNullFieldException("s3BucketName"),
            s3KeyName = s3KeyName,
        )
}
