@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.customerprofiles.kotlin.inputs

import com.pulumi.aws.customerprofiles.inputs.DomainMatchingJobScheduleArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property dayOfTheWeek The day when the Identity Resolution Job should run every week.
 * @property time The time when the Identity Resolution Job should run every week.
 */
public data class DomainMatchingJobScheduleArgs(
    public val dayOfTheWeek: Output<String>,
    public val time: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.customerprofiles.inputs.DomainMatchingJobScheduleArgs> {
    override fun toJava(): com.pulumi.aws.customerprofiles.inputs.DomainMatchingJobScheduleArgs =
        com.pulumi.aws.customerprofiles.inputs.DomainMatchingJobScheduleArgs.builder()
            .dayOfTheWeek(dayOfTheWeek.applyValue({ args0 -> args0 }))
            .time(time.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DomainMatchingJobScheduleArgs].
 */
@PulumiTagMarker
public class DomainMatchingJobScheduleArgsBuilder internal constructor() {
    private var dayOfTheWeek: Output<String>? = null

    private var time: Output<String>? = null

    /**
     * @param value The day when the Identity Resolution Job should run every week.
     */
    @JvmName("biovgxqmwbknvgnr")
    public suspend fun dayOfTheWeek(`value`: Output<String>) {
        this.dayOfTheWeek = value
    }

    /**
     * @param value The time when the Identity Resolution Job should run every week.
     */
    @JvmName("gwpwhfydrtgxaruk")
    public suspend fun time(`value`: Output<String>) {
        this.time = value
    }

    /**
     * @param value The day when the Identity Resolution Job should run every week.
     */
    @JvmName("kpkhuhlctnhatoxd")
    public suspend fun dayOfTheWeek(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.dayOfTheWeek = mapped
    }

    /**
     * @param value The time when the Identity Resolution Job should run every week.
     */
    @JvmName("uxwmihwpyrwtxifi")
    public suspend fun time(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.time = mapped
    }

    internal fun build(): DomainMatchingJobScheduleArgs = DomainMatchingJobScheduleArgs(
        dayOfTheWeek = dayOfTheWeek ?: throw PulumiNullFieldException("dayOfTheWeek"),
        time = time ?: throw PulumiNullFieldException("time"),
    )
}
