@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.customerprofiles.kotlin.inputs

import com.pulumi.aws.customerprofiles.inputs.DomainRuleBasedMatchingArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property attributeTypesSelector A block that configures information about the `AttributeTypesSelector` where the rule-based identity resolution uses to match profiles. Documented below.
 * @property conflictResolution A block that specifies how the auto-merging process should resolve conflicts between different profiles. Documented below.
 * @property enabled The flag that enables the rule-based matching process of duplicate profiles.
 * @property exportingConfig A block that specifies the configuration for exporting Identity Resolution results. Documented below.
 * @property matchingRules A block that configures how the rule-based matching process should match profiles. You can have up to 15 `rule` in the `natching_rules`. Documented below.
 * @property maxAllowedRuleLevelForMatching Indicates the maximum allowed rule level for matching.
 * @property maxAllowedRuleLevelForMerging Indicates the maximum allowed rule level for merging.
 * @property status
 */
public data class DomainRuleBasedMatchingArgs(
    public val attributeTypesSelector: Output<DomainRuleBasedMatchingAttributeTypesSelectorArgs>? =
        null,
    public val conflictResolution: Output<DomainRuleBasedMatchingConflictResolutionArgs>? = null,
    public val enabled: Output<Boolean>,
    public val exportingConfig: Output<DomainRuleBasedMatchingExportingConfigArgs>? = null,
    public val matchingRules: Output<List<DomainRuleBasedMatchingMatchingRuleArgs>>? = null,
    public val maxAllowedRuleLevelForMatching: Output<Int>? = null,
    public val maxAllowedRuleLevelForMerging: Output<Int>? = null,
    public val status: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.customerprofiles.inputs.DomainRuleBasedMatchingArgs> {
    override fun toJava(): com.pulumi.aws.customerprofiles.inputs.DomainRuleBasedMatchingArgs =
        com.pulumi.aws.customerprofiles.inputs.DomainRuleBasedMatchingArgs.builder()
            .attributeTypesSelector(
                attributeTypesSelector?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .conflictResolution(
                conflictResolution?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .enabled(enabled.applyValue({ args0 -> args0 }))
            .exportingConfig(exportingConfig?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .matchingRules(
                matchingRules?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .maxAllowedRuleLevelForMatching(maxAllowedRuleLevelForMatching?.applyValue({ args0 -> args0 }))
            .maxAllowedRuleLevelForMerging(maxAllowedRuleLevelForMerging?.applyValue({ args0 -> args0 }))
            .status(status?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DomainRuleBasedMatchingArgs].
 */
@PulumiTagMarker
public class DomainRuleBasedMatchingArgsBuilder internal constructor() {
    private var attributeTypesSelector: Output<DomainRuleBasedMatchingAttributeTypesSelectorArgs>? =
        null

    private var conflictResolution: Output<DomainRuleBasedMatchingConflictResolutionArgs>? = null

    private var enabled: Output<Boolean>? = null

    private var exportingConfig: Output<DomainRuleBasedMatchingExportingConfigArgs>? = null

    private var matchingRules: Output<List<DomainRuleBasedMatchingMatchingRuleArgs>>? = null

    private var maxAllowedRuleLevelForMatching: Output<Int>? = null

    private var maxAllowedRuleLevelForMerging: Output<Int>? = null

    private var status: Output<String>? = null

    /**
     * @param value A block that configures information about the `AttributeTypesSelector` where the rule-based identity resolution uses to match profiles. Documented below.
     */
    @JvmName("xrxxujsrjersmgbq")
    public suspend fun attributeTypesSelector(`value`: Output<DomainRuleBasedMatchingAttributeTypesSelectorArgs>) {
        this.attributeTypesSelector = value
    }

    /**
     * @param value A block that specifies how the auto-merging process should resolve conflicts between different profiles. Documented below.
     */
    @JvmName("cxaygxdnbqgmbdaq")
    public suspend fun conflictResolution(`value`: Output<DomainRuleBasedMatchingConflictResolutionArgs>) {
        this.conflictResolution = value
    }

    /**
     * @param value The flag that enables the rule-based matching process of duplicate profiles.
     */
    @JvmName("xyxkrplcofidlrqg")
    public suspend fun enabled(`value`: Output<Boolean>) {
        this.enabled = value
    }

    /**
     * @param value A block that specifies the configuration for exporting Identity Resolution results. Documented below.
     */
    @JvmName("wpqknqmtaokytevs")
    public suspend fun exportingConfig(`value`: Output<DomainRuleBasedMatchingExportingConfigArgs>) {
        this.exportingConfig = value
    }

    /**
     * @param value A block that configures how the rule-based matching process should match profiles. You can have up to 15 `rule` in the `natching_rules`. Documented below.
     */
    @JvmName("phjhrysbovgybdyi")
    public suspend fun matchingRules(`value`: Output<List<DomainRuleBasedMatchingMatchingRuleArgs>>) {
        this.matchingRules = value
    }

    @JvmName("hhgummccpfyetios")
    public suspend fun matchingRules(vararg values: Output<DomainRuleBasedMatchingMatchingRuleArgs>) {
        this.matchingRules = Output.all(values.asList())
    }

    /**
     * @param values A block that configures how the rule-based matching process should match profiles. You can have up to 15 `rule` in the `natching_rules`. Documented below.
     */
    @JvmName("hbgvghlxbrtgcuwh")
    public suspend fun matchingRules(values: List<Output<DomainRuleBasedMatchingMatchingRuleArgs>>) {
        this.matchingRules = Output.all(values)
    }

    /**
     * @param value Indicates the maximum allowed rule level for matching.
     */
    @JvmName("rgrlxwepblbxfbmc")
    public suspend fun maxAllowedRuleLevelForMatching(`value`: Output<Int>) {
        this.maxAllowedRuleLevelForMatching = value
    }

    /**
     * @param value Indicates the maximum allowed rule level for merging.
     */
    @JvmName("eobbppotclaqomal")
    public suspend fun maxAllowedRuleLevelForMerging(`value`: Output<Int>) {
        this.maxAllowedRuleLevelForMerging = value
    }

    /**
     * @param value
     */
    @JvmName("irohffucnkbyicmi")
    public suspend fun status(`value`: Output<String>) {
        this.status = value
    }

    /**
     * @param value A block that configures information about the `AttributeTypesSelector` where the rule-based identity resolution uses to match profiles. Documented below.
     */
    @JvmName("iubcgrxvmjyiybpc")
    public suspend fun attributeTypesSelector(`value`: DomainRuleBasedMatchingAttributeTypesSelectorArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.attributeTypesSelector = mapped
    }

    /**
     * @param argument A block that configures information about the `AttributeTypesSelector` where the rule-based identity resolution uses to match profiles. Documented below.
     */
    @JvmName("fylvjtftrxwvxjia")
    public suspend fun attributeTypesSelector(argument: suspend DomainRuleBasedMatchingAttributeTypesSelectorArgsBuilder.() -> Unit) {
        val toBeMapped = DomainRuleBasedMatchingAttributeTypesSelectorArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.attributeTypesSelector = mapped
    }

    /**
     * @param value A block that specifies how the auto-merging process should resolve conflicts between different profiles. Documented below.
     */
    @JvmName("liwmwautirpkrugi")
    public suspend fun conflictResolution(`value`: DomainRuleBasedMatchingConflictResolutionArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.conflictResolution = mapped
    }

    /**
     * @param argument A block that specifies how the auto-merging process should resolve conflicts between different profiles. Documented below.
     */
    @JvmName("acebwqipvuagvote")
    public suspend fun conflictResolution(argument: suspend DomainRuleBasedMatchingConflictResolutionArgsBuilder.() -> Unit) {
        val toBeMapped = DomainRuleBasedMatchingConflictResolutionArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.conflictResolution = mapped
    }

    /**
     * @param value The flag that enables the rule-based matching process of duplicate profiles.
     */
    @JvmName("juuhgmdyxfalnsco")
    public suspend fun enabled(`value`: Boolean) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.enabled = mapped
    }

    /**
     * @param value A block that specifies the configuration for exporting Identity Resolution results. Documented below.
     */
    @JvmName("ujtxkmsunnructft")
    public suspend fun exportingConfig(`value`: DomainRuleBasedMatchingExportingConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.exportingConfig = mapped
    }

    /**
     * @param argument A block that specifies the configuration for exporting Identity Resolution results. Documented below.
     */
    @JvmName("lqqwlgiowppnpbrm")
    public suspend fun exportingConfig(argument: suspend DomainRuleBasedMatchingExportingConfigArgsBuilder.() -> Unit) {
        val toBeMapped = DomainRuleBasedMatchingExportingConfigArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.exportingConfig = mapped
    }

    /**
     * @param value A block that configures how the rule-based matching process should match profiles. You can have up to 15 `rule` in the `natching_rules`. Documented below.
     */
    @JvmName("bwvgpnkyqtmimnai")
    public suspend fun matchingRules(`value`: List<DomainRuleBasedMatchingMatchingRuleArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.matchingRules = mapped
    }

    /**
     * @param argument A block that configures how the rule-based matching process should match profiles. You can have up to 15 `rule` in the `natching_rules`. Documented below.
     */
    @JvmName("ivaajmpiyolgvolb")
    public suspend fun matchingRules(argument: List<suspend DomainRuleBasedMatchingMatchingRuleArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            DomainRuleBasedMatchingMatchingRuleArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.matchingRules = mapped
    }

    /**
     * @param argument A block that configures how the rule-based matching process should match profiles. You can have up to 15 `rule` in the `natching_rules`. Documented below.
     */
    @JvmName("oswbicxwijyyxjvx")
    public suspend fun matchingRules(vararg argument: suspend DomainRuleBasedMatchingMatchingRuleArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            DomainRuleBasedMatchingMatchingRuleArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.matchingRules = mapped
    }

    /**
     * @param argument A block that configures how the rule-based matching process should match profiles. You can have up to 15 `rule` in the `natching_rules`. Documented below.
     */
    @JvmName("nbdaltkhhtgbmrko")
    public suspend fun matchingRules(argument: suspend DomainRuleBasedMatchingMatchingRuleArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            DomainRuleBasedMatchingMatchingRuleArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.matchingRules = mapped
    }

    /**
     * @param values A block that configures how the rule-based matching process should match profiles. You can have up to 15 `rule` in the `natching_rules`. Documented below.
     */
    @JvmName("jvcpedhxcljeqdsk")
    public suspend fun matchingRules(vararg values: DomainRuleBasedMatchingMatchingRuleArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.matchingRules = mapped
    }

    /**
     * @param value Indicates the maximum allowed rule level for matching.
     */
    @JvmName("akuoayqlfocmkspx")
    public suspend fun maxAllowedRuleLevelForMatching(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maxAllowedRuleLevelForMatching = mapped
    }

    /**
     * @param value Indicates the maximum allowed rule level for merging.
     */
    @JvmName("iswrtusnjbkafsgi")
    public suspend fun maxAllowedRuleLevelForMerging(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maxAllowedRuleLevelForMerging = mapped
    }

    /**
     * @param value
     */
    @JvmName("imajqiciabgtqwub")
    public suspend fun status(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.status = mapped
    }

    internal fun build(): DomainRuleBasedMatchingArgs = DomainRuleBasedMatchingArgs(
        attributeTypesSelector = attributeTypesSelector,
        conflictResolution = conflictResolution,
        enabled = enabled ?: throw PulumiNullFieldException("enabled"),
        exportingConfig = exportingConfig,
        matchingRules = matchingRules,
        maxAllowedRuleLevelForMatching = maxAllowedRuleLevelForMatching,
        maxAllowedRuleLevelForMerging = maxAllowedRuleLevelForMerging,
        status = status,
    )
}
