@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.customerprofiles.kotlin.inputs

import com.pulumi.aws.customerprofiles.inputs.DomainRuleBasedMatchingAttributeTypesSelectorArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property addresses The `Address` type. You can choose from `Address`, `BusinessAddress`, `MaillingAddress`, and `ShippingAddress`.
 * @property attributeMatchingModel Configures the `AttributeMatchingModel`, you can either choose `ONE_TO_ONE` or `MANY_TO_MANY`.
 * @property emailAddresses The `Email` type. You can choose from `EmailAddress`, `BusinessEmailAddress` and `PersonalEmailAddress`.
 * @property phoneNumbers The `PhoneNumber` type. You can choose from `PhoneNumber`, `HomePhoneNumber`, and `MobilePhoneNumber`.
 */
public data class DomainRuleBasedMatchingAttributeTypesSelectorArgs(
    public val addresses: Output<List<String>>? = null,
    public val attributeMatchingModel: Output<String>,
    public val emailAddresses: Output<List<String>>? = null,
    public val phoneNumbers: Output<List<String>>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.customerprofiles.inputs.DomainRuleBasedMatchingAttributeTypesSelectorArgs> {
    override fun toJava(): com.pulumi.aws.customerprofiles.inputs.DomainRuleBasedMatchingAttributeTypesSelectorArgs =
        com.pulumi.aws.customerprofiles.inputs.DomainRuleBasedMatchingAttributeTypesSelectorArgs.builder()
            .addresses(addresses?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .attributeMatchingModel(attributeMatchingModel.applyValue({ args0 -> args0 }))
            .emailAddresses(emailAddresses?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .phoneNumbers(phoneNumbers?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [DomainRuleBasedMatchingAttributeTypesSelectorArgs].
 */
@PulumiTagMarker
public class DomainRuleBasedMatchingAttributeTypesSelectorArgsBuilder internal constructor() {
    private var addresses: Output<List<String>>? = null

    private var attributeMatchingModel: Output<String>? = null

    private var emailAddresses: Output<List<String>>? = null

    private var phoneNumbers: Output<List<String>>? = null

    /**
     * @param value The `Address` type. You can choose from `Address`, `BusinessAddress`, `MaillingAddress`, and `ShippingAddress`.
     */
    @JvmName("lgorvtsfaiyxdfar")
    public suspend fun addresses(`value`: Output<List<String>>) {
        this.addresses = value
    }

    @JvmName("ykxcretxekdijsmj")
    public suspend fun addresses(vararg values: Output<String>) {
        this.addresses = Output.all(values.asList())
    }

    /**
     * @param values The `Address` type. You can choose from `Address`, `BusinessAddress`, `MaillingAddress`, and `ShippingAddress`.
     */
    @JvmName("rgwrgfaexsdistid")
    public suspend fun addresses(values: List<Output<String>>) {
        this.addresses = Output.all(values)
    }

    /**
     * @param value Configures the `AttributeMatchingModel`, you can either choose `ONE_TO_ONE` or `MANY_TO_MANY`.
     */
    @JvmName("qpmlfmequemmlnax")
    public suspend fun attributeMatchingModel(`value`: Output<String>) {
        this.attributeMatchingModel = value
    }

    /**
     * @param value The `Email` type. You can choose from `EmailAddress`, `BusinessEmailAddress` and `PersonalEmailAddress`.
     */
    @JvmName("hdxikddunfyfxqqx")
    public suspend fun emailAddresses(`value`: Output<List<String>>) {
        this.emailAddresses = value
    }

    @JvmName("bycmisebshbvryfx")
    public suspend fun emailAddresses(vararg values: Output<String>) {
        this.emailAddresses = Output.all(values.asList())
    }

    /**
     * @param values The `Email` type. You can choose from `EmailAddress`, `BusinessEmailAddress` and `PersonalEmailAddress`.
     */
    @JvmName("kcpydenkcwvwlegl")
    public suspend fun emailAddresses(values: List<Output<String>>) {
        this.emailAddresses = Output.all(values)
    }

    /**
     * @param value The `PhoneNumber` type. You can choose from `PhoneNumber`, `HomePhoneNumber`, and `MobilePhoneNumber`.
     */
    @JvmName("ivfwfsgwicsfrvdj")
    public suspend fun phoneNumbers(`value`: Output<List<String>>) {
        this.phoneNumbers = value
    }

    @JvmName("ofmhypethebxiakd")
    public suspend fun phoneNumbers(vararg values: Output<String>) {
        this.phoneNumbers = Output.all(values.asList())
    }

    /**
     * @param values The `PhoneNumber` type. You can choose from `PhoneNumber`, `HomePhoneNumber`, and `MobilePhoneNumber`.
     */
    @JvmName("lqcgtgegojbrbxne")
    public suspend fun phoneNumbers(values: List<Output<String>>) {
        this.phoneNumbers = Output.all(values)
    }

    /**
     * @param value The `Address` type. You can choose from `Address`, `BusinessAddress`, `MaillingAddress`, and `ShippingAddress`.
     */
    @JvmName("waedtbxbxbjffmbj")
    public suspend fun addresses(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.addresses = mapped
    }

    /**
     * @param values The `Address` type. You can choose from `Address`, `BusinessAddress`, `MaillingAddress`, and `ShippingAddress`.
     */
    @JvmName("myusmdidqvqhqfgf")
    public suspend fun addresses(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.addresses = mapped
    }

    /**
     * @param value Configures the `AttributeMatchingModel`, you can either choose `ONE_TO_ONE` or `MANY_TO_MANY`.
     */
    @JvmName("rhhofpabqppeiali")
    public suspend fun attributeMatchingModel(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.attributeMatchingModel = mapped
    }

    /**
     * @param value The `Email` type. You can choose from `EmailAddress`, `BusinessEmailAddress` and `PersonalEmailAddress`.
     */
    @JvmName("kwthsfvsotebjnoh")
    public suspend fun emailAddresses(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.emailAddresses = mapped
    }

    /**
     * @param values The `Email` type. You can choose from `EmailAddress`, `BusinessEmailAddress` and `PersonalEmailAddress`.
     */
    @JvmName("otqlyhyofvcjjkem")
    public suspend fun emailAddresses(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.emailAddresses = mapped
    }

    /**
     * @param value The `PhoneNumber` type. You can choose from `PhoneNumber`, `HomePhoneNumber`, and `MobilePhoneNumber`.
     */
    @JvmName("xsqswxmhiovcrafg")
    public suspend fun phoneNumbers(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.phoneNumbers = mapped
    }

    /**
     * @param values The `PhoneNumber` type. You can choose from `PhoneNumber`, `HomePhoneNumber`, and `MobilePhoneNumber`.
     */
    @JvmName("tugwmubkjakvppab")
    public suspend fun phoneNumbers(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.phoneNumbers = mapped
    }

    internal fun build(): DomainRuleBasedMatchingAttributeTypesSelectorArgs =
        DomainRuleBasedMatchingAttributeTypesSelectorArgs(
            addresses = addresses,
            attributeMatchingModel = attributeMatchingModel ?: throw
                PulumiNullFieldException("attributeMatchingModel"),
            emailAddresses = emailAddresses,
            phoneNumbers = phoneNumbers,
        )
}
