@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.customerprofiles.kotlin.inputs

import com.pulumi.aws.customerprofiles.inputs.DomainRuleBasedMatchingConflictResolutionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property conflictResolvingModel How the auto-merging process should resolve conflicts between different profiles. Valid values are `RECENCY` and `SOURCE`
 * @property sourceName The `ObjectType` name that is used to resolve profile merging conflicts when choosing `SOURCE` as the `ConflictResolvingModel`.
 */
public data class DomainRuleBasedMatchingConflictResolutionArgs(
    public val conflictResolvingModel: Output<String>,
    public val sourceName: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.customerprofiles.inputs.DomainRuleBasedMatchingConflictResolutionArgs> {
    override fun toJava(): com.pulumi.aws.customerprofiles.inputs.DomainRuleBasedMatchingConflictResolutionArgs =
        com.pulumi.aws.customerprofiles.inputs.DomainRuleBasedMatchingConflictResolutionArgs.builder()
            .conflictResolvingModel(conflictResolvingModel.applyValue({ args0 -> args0 }))
            .sourceName(sourceName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DomainRuleBasedMatchingConflictResolutionArgs].
 */
@PulumiTagMarker
public class DomainRuleBasedMatchingConflictResolutionArgsBuilder internal constructor() {
    private var conflictResolvingModel: Output<String>? = null

    private var sourceName: Output<String>? = null

    /**
     * @param value How the auto-merging process should resolve conflicts between different profiles. Valid values are `RECENCY` and `SOURCE`
     */
    @JvmName("xscqimnywmkbvmka")
    public suspend fun conflictResolvingModel(`value`: Output<String>) {
        this.conflictResolvingModel = value
    }

    /**
     * @param value The `ObjectType` name that is used to resolve profile merging conflicts when choosing `SOURCE` as the `ConflictResolvingModel`.
     */
    @JvmName("hkmffvjuiaydpvcl")
    public suspend fun sourceName(`value`: Output<String>) {
        this.sourceName = value
    }

    /**
     * @param value How the auto-merging process should resolve conflicts between different profiles. Valid values are `RECENCY` and `SOURCE`
     */
    @JvmName("wkhxlwkfmgrelmsp")
    public suspend fun conflictResolvingModel(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.conflictResolvingModel = mapped
    }

    /**
     * @param value The `ObjectType` name that is used to resolve profile merging conflicts when choosing `SOURCE` as the `ConflictResolvingModel`.
     */
    @JvmName("nviywwgagtfdtyqo")
    public suspend fun sourceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceName = mapped
    }

    internal fun build(): DomainRuleBasedMatchingConflictResolutionArgs =
        DomainRuleBasedMatchingConflictResolutionArgs(
            conflictResolvingModel = conflictResolvingModel ?: throw
                PulumiNullFieldException("conflictResolvingModel"),
            sourceName = sourceName,
        )
}
