@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.customerprofiles.kotlin.inputs

import com.pulumi.aws.customerprofiles.inputs.DomainRuleBasedMatchingMatchingRuleArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property rules A single rule level of the `match_rules`. Configures how the rule-based matching process should match profiles.
 */
public data class DomainRuleBasedMatchingMatchingRuleArgs(
    public val rules: Output<List<String>>,
) :
    ConvertibleToJava<com.pulumi.aws.customerprofiles.inputs.DomainRuleBasedMatchingMatchingRuleArgs> {
    override fun toJava(): com.pulumi.aws.customerprofiles.inputs.DomainRuleBasedMatchingMatchingRuleArgs =
        com.pulumi.aws.customerprofiles.inputs.DomainRuleBasedMatchingMatchingRuleArgs.builder()
            .rules(rules.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [DomainRuleBasedMatchingMatchingRuleArgs].
 */
@PulumiTagMarker
public class DomainRuleBasedMatchingMatchingRuleArgsBuilder internal constructor() {
    private var rules: Output<List<String>>? = null

    /**
     * @param value A single rule level of the `match_rules`. Configures how the rule-based matching process should match profiles.
     */
    @JvmName("duabyuycfqepdnhp")
    public suspend fun rules(`value`: Output<List<String>>) {
        this.rules = value
    }

    @JvmName("eicnyprsdnseliqg")
    public suspend fun rules(vararg values: Output<String>) {
        this.rules = Output.all(values.asList())
    }

    /**
     * @param values A single rule level of the `match_rules`. Configures how the rule-based matching process should match profiles.
     */
    @JvmName("ercgwxugtjydyqnt")
    public suspend fun rules(values: List<Output<String>>) {
        this.rules = Output.all(values)
    }

    /**
     * @param value A single rule level of the `match_rules`. Configures how the rule-based matching process should match profiles.
     */
    @JvmName("dxwbcdessrjtghxr")
    public suspend fun rules(`value`: List<String>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.rules = mapped
    }

    /**
     * @param values A single rule level of the `match_rules`. Configures how the rule-based matching process should match profiles.
     */
    @JvmName("hwxgtilweynmbqyr")
    public suspend fun rules(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.rules = mapped
    }

    internal fun build(): DomainRuleBasedMatchingMatchingRuleArgs =
        DomainRuleBasedMatchingMatchingRuleArgs(
            rules = rules ?: throw PulumiNullFieldException("rules"),
        )
}
