@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.customerprofiles.kotlin.inputs

import com.pulumi.aws.customerprofiles.inputs.ProfileAddressArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property address1 The first line of a customer address.
 * @property address2 The second line of a customer address.
 * @property address3 The third line of a customer address.
 * @property address4 The fourth line of a customer address.
 * @property city The city in which a customer lives.
 * @property country The country in which a customer lives.
 * @property county The county in which a customer lives.
 * @property postalCode The postal code of a customer address.
 * @property province The province in which a customer lives.
 * @property state The state in which a customer lives.
 */
public data class ProfileAddressArgs(
    public val address1: Output<String>? = null,
    public val address2: Output<String>? = null,
    public val address3: Output<String>? = null,
    public val address4: Output<String>? = null,
    public val city: Output<String>? = null,
    public val country: Output<String>? = null,
    public val county: Output<String>? = null,
    public val postalCode: Output<String>? = null,
    public val province: Output<String>? = null,
    public val state: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.customerprofiles.inputs.ProfileAddressArgs> {
    override fun toJava(): com.pulumi.aws.customerprofiles.inputs.ProfileAddressArgs =
        com.pulumi.aws.customerprofiles.inputs.ProfileAddressArgs.builder()
            .address1(address1?.applyValue({ args0 -> args0 }))
            .address2(address2?.applyValue({ args0 -> args0 }))
            .address3(address3?.applyValue({ args0 -> args0 }))
            .address4(address4?.applyValue({ args0 -> args0 }))
            .city(city?.applyValue({ args0 -> args0 }))
            .country(country?.applyValue({ args0 -> args0 }))
            .county(county?.applyValue({ args0 -> args0 }))
            .postalCode(postalCode?.applyValue({ args0 -> args0 }))
            .province(province?.applyValue({ args0 -> args0 }))
            .state(state?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ProfileAddressArgs].
 */
@PulumiTagMarker
public class ProfileAddressArgsBuilder internal constructor() {
    private var address1: Output<String>? = null

    private var address2: Output<String>? = null

    private var address3: Output<String>? = null

    private var address4: Output<String>? = null

    private var city: Output<String>? = null

    private var country: Output<String>? = null

    private var county: Output<String>? = null

    private var postalCode: Output<String>? = null

    private var province: Output<String>? = null

    private var state: Output<String>? = null

    /**
     * @param value The first line of a customer address.
     */
    @JvmName("fsqnnqaejukipsnq")
    public suspend fun address1(`value`: Output<String>) {
        this.address1 = value
    }

    /**
     * @param value The second line of a customer address.
     */
    @JvmName("biyissrduhmtmrqf")
    public suspend fun address2(`value`: Output<String>) {
        this.address2 = value
    }

    /**
     * @param value The third line of a customer address.
     */
    @JvmName("duckcasxgbivlhrb")
    public suspend fun address3(`value`: Output<String>) {
        this.address3 = value
    }

    /**
     * @param value The fourth line of a customer address.
     */
    @JvmName("ijukbwuhhpykvisy")
    public suspend fun address4(`value`: Output<String>) {
        this.address4 = value
    }

    /**
     * @param value The city in which a customer lives.
     */
    @JvmName("glbobjhxwodmcynf")
    public suspend fun city(`value`: Output<String>) {
        this.city = value
    }

    /**
     * @param value The country in which a customer lives.
     */
    @JvmName("qebirgptpxysytnu")
    public suspend fun country(`value`: Output<String>) {
        this.country = value
    }

    /**
     * @param value The county in which a customer lives.
     */
    @JvmName("ojunuxnxwevyteld")
    public suspend fun county(`value`: Output<String>) {
        this.county = value
    }

    /**
     * @param value The postal code of a customer address.
     */
    @JvmName("mgbgvrjkiwiducux")
    public suspend fun postalCode(`value`: Output<String>) {
        this.postalCode = value
    }

    /**
     * @param value The province in which a customer lives.
     */
    @JvmName("mtxdxqijgbjffajg")
    public suspend fun province(`value`: Output<String>) {
        this.province = value
    }

    /**
     * @param value The state in which a customer lives.
     */
    @JvmName("afimcidwvgxooatr")
    public suspend fun state(`value`: Output<String>) {
        this.state = value
    }

    /**
     * @param value The first line of a customer address.
     */
    @JvmName("xkvuubfsokyfvoab")
    public suspend fun address1(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.address1 = mapped
    }

    /**
     * @param value The second line of a customer address.
     */
    @JvmName("ahwvfgfptwkpwhot")
    public suspend fun address2(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.address2 = mapped
    }

    /**
     * @param value The third line of a customer address.
     */
    @JvmName("yicdspclpsudcujb")
    public suspend fun address3(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.address3 = mapped
    }

    /**
     * @param value The fourth line of a customer address.
     */
    @JvmName("ncwavngrtwgvrnam")
    public suspend fun address4(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.address4 = mapped
    }

    /**
     * @param value The city in which a customer lives.
     */
    @JvmName("tgwrojgwlrwbvtir")
    public suspend fun city(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.city = mapped
    }

    /**
     * @param value The country in which a customer lives.
     */
    @JvmName("hraeofvrxedogbgl")
    public suspend fun country(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.country = mapped
    }

    /**
     * @param value The county in which a customer lives.
     */
    @JvmName("absvrdmxwvmxnkso")
    public suspend fun county(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.county = mapped
    }

    /**
     * @param value The postal code of a customer address.
     */
    @JvmName("oldrfmewogjrdrhl")
    public suspend fun postalCode(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.postalCode = mapped
    }

    /**
     * @param value The province in which a customer lives.
     */
    @JvmName("fronkgujjjaaaunr")
    public suspend fun province(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.province = mapped
    }

    /**
     * @param value The state in which a customer lives.
     */
    @JvmName("rkvlwramyfadoctp")
    public suspend fun state(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.state = mapped
    }

    internal fun build(): ProfileAddressArgs = ProfileAddressArgs(
        address1 = address1,
        address2 = address2,
        address3 = address3,
        address4 = address4,
        city = city,
        country = country,
        county = county,
        postalCode = postalCode,
        province = province,
        state = state,
    )
}
