@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.customerprofiles.kotlin.outputs

import kotlin.Boolean
import kotlin.Suppress

/**
 *
 * @property autoMerging A block that specifies the configuration about the auto-merging process. Documented below.
 * @property enabled The flag that enables the matching process of duplicate profiles.
 * @property exportingConfig A block that specifies the configuration for exporting Identity Resolution results. Documented below.
 * @property jobSchedule A block that specifies the day and time when you want to start the Identity Resolution Job every week. Documented below.
 */
public data class DomainMatching(
    public val autoMerging: DomainMatchingAutoMerging? = null,
    public val enabled: Boolean,
    public val exportingConfig: DomainMatchingExportingConfig? = null,
    public val jobSchedule: DomainMatchingJobSchedule? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.customerprofiles.outputs.DomainMatching): DomainMatching = DomainMatching(
            autoMerging = javaType.autoMerging().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.customerprofiles.kotlin.outputs.DomainMatchingAutoMerging.Companion.toKotlin(args0)
                })
            }).orElse(null),
            enabled = javaType.enabled(),
            exportingConfig = javaType.exportingConfig().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.customerprofiles.kotlin.outputs.DomainMatchingExportingConfig.Companion.toKotlin(args0)
                })
            }).orElse(null),
            jobSchedule = javaType.jobSchedule().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.customerprofiles.kotlin.outputs.DomainMatchingJobSchedule.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
