@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.customerprofiles.kotlin.outputs

import kotlin.Boolean
import kotlin.Double
import kotlin.Suppress

/**
 *
 * @property conflictResolution A block that specifies how the auto-merging process should resolve conflicts between different profiles. Documented below.
 * @property consolidation A block that specifies a list of matching attributes that represent matching criteria. If two profiles meet at least one of the requirements in the matching attributes list, they will be merged. Documented below.
 * * `min_allowed_confidence_score_for_merging ` - (Optional) A number between 0 and 1 that represents the minimum confidence score required for profiles within a matching group to be merged during the auto-merge process. A higher score means higher similarity required to merge profiles.
 * @property enabled The flag that enables the auto-merging of duplicate profiles.
 * @property minAllowedConfidenceScoreForMerging
 */
public data class DomainMatchingAutoMerging(
    public val conflictResolution: DomainMatchingAutoMergingConflictResolution? = null,
    public val consolidation: DomainMatchingAutoMergingConsolidation? = null,
    public val enabled: Boolean,
    public val minAllowedConfidenceScoreForMerging: Double? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.customerprofiles.outputs.DomainMatchingAutoMerging): DomainMatchingAutoMerging = DomainMatchingAutoMerging(
            conflictResolution = javaType.conflictResolution().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.customerprofiles.kotlin.outputs.DomainMatchingAutoMergingConflictResolution.Companion.toKotlin(args0)
                })
            }).orElse(null),
            consolidation = javaType.consolidation().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.customerprofiles.kotlin.outputs.DomainMatchingAutoMergingConsolidation.Companion.toKotlin(args0)
                })
            }).orElse(null),
            enabled = javaType.enabled(),
            minAllowedConfidenceScoreForMerging = javaType.minAllowedConfidenceScoreForMerging().map({ args0 ->
                args0
            }).orElse(null),
        )
    }
}
