@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.customerprofiles.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property dayOfTheWeek The day when the Identity Resolution Job should run every week.
 * @property time The time when the Identity Resolution Job should run every week.
 */
public data class DomainMatchingJobSchedule(
    public val dayOfTheWeek: String,
    public val time: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.customerprofiles.outputs.DomainMatchingJobSchedule): DomainMatchingJobSchedule = DomainMatchingJobSchedule(
            dayOfTheWeek = javaType.dayOfTheWeek(),
            time = javaType.time(),
        )
    }
}
