@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.customerprofiles.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property attributeTypesSelector A block that configures information about the `AttributeTypesSelector` where the rule-based identity resolution uses to match profiles. Documented below.
 * @property conflictResolution A block that specifies how the auto-merging process should resolve conflicts between different profiles. Documented below.
 * @property enabled The flag that enables the rule-based matching process of duplicate profiles.
 * @property exportingConfig A block that specifies the configuration for exporting Identity Resolution results. Documented below.
 * @property matchingRules A block that configures how the rule-based matching process should match profiles. You can have up to 15 `rule` in the `natching_rules`. Documented below.
 * @property maxAllowedRuleLevelForMatching Indicates the maximum allowed rule level for matching.
 * @property maxAllowedRuleLevelForMerging Indicates the maximum allowed rule level for merging.
 * @property status
 */
public data class DomainRuleBasedMatching(
    public val attributeTypesSelector: DomainRuleBasedMatchingAttributeTypesSelector? = null,
    public val conflictResolution: DomainRuleBasedMatchingConflictResolution? = null,
    public val enabled: Boolean,
    public val exportingConfig: DomainRuleBasedMatchingExportingConfig? = null,
    public val matchingRules: List<DomainRuleBasedMatchingMatchingRule>? = null,
    public val maxAllowedRuleLevelForMatching: Int? = null,
    public val maxAllowedRuleLevelForMerging: Int? = null,
    public val status: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.customerprofiles.outputs.DomainRuleBasedMatching): DomainRuleBasedMatching = DomainRuleBasedMatching(
            attributeTypesSelector = javaType.attributeTypesSelector().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.customerprofiles.kotlin.outputs.DomainRuleBasedMatchingAttributeTypesSelector.Companion.toKotlin(args0)
                })
            }).orElse(null),
            conflictResolution = javaType.conflictResolution().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.customerprofiles.kotlin.outputs.DomainRuleBasedMatchingConflictResolution.Companion.toKotlin(args0)
                })
            }).orElse(null),
            enabled = javaType.enabled(),
            exportingConfig = javaType.exportingConfig().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.customerprofiles.kotlin.outputs.DomainRuleBasedMatchingExportingConfig.Companion.toKotlin(args0)
                })
            }).orElse(null),
            matchingRules = javaType.matchingRules().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.customerprofiles.kotlin.outputs.DomainRuleBasedMatchingMatchingRule.Companion.toKotlin(args0)
                })
            }),
            maxAllowedRuleLevelForMatching = javaType.maxAllowedRuleLevelForMatching().map({ args0 ->
                args0
            }).orElse(null),
            maxAllowedRuleLevelForMerging = javaType.maxAllowedRuleLevelForMerging().map({ args0 ->
                args0
            }).orElse(null),
            status = javaType.status().map({ args0 -> args0 }).orElse(null),
        )
    }
}
