@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.customerprofiles.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property addresses The `Address` type. You can choose from `Address`, `BusinessAddress`, `MaillingAddress`, and `ShippingAddress`.
 * @property attributeMatchingModel Configures the `AttributeMatchingModel`, you can either choose `ONE_TO_ONE` or `MANY_TO_MANY`.
 * @property emailAddresses The `Email` type. You can choose from `EmailAddress`, `BusinessEmailAddress` and `PersonalEmailAddress`.
 * @property phoneNumbers The `PhoneNumber` type. You can choose from `PhoneNumber`, `HomePhoneNumber`, and `MobilePhoneNumber`.
 */
public data class DomainRuleBasedMatchingAttributeTypesSelector(
    public val addresses: List<String>? = null,
    public val attributeMatchingModel: String,
    public val emailAddresses: List<String>? = null,
    public val phoneNumbers: List<String>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.customerprofiles.outputs.DomainRuleBasedMatchingAttributeTypesSelector): DomainRuleBasedMatchingAttributeTypesSelector =
            DomainRuleBasedMatchingAttributeTypesSelector(
                addresses = javaType.addresses().map({ args0 -> args0 }),
                attributeMatchingModel = javaType.attributeMatchingModel(),
                emailAddresses = javaType.emailAddresses().map({ args0 -> args0 }),
                phoneNumbers = javaType.phoneNumbers().map({ args0 -> args0 }),
            )
    }
}
