@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.customerprofiles.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property conflictResolvingModel How the auto-merging process should resolve conflicts between different profiles. Valid values are `RECENCY` and `SOURCE`
 * @property sourceName The `ObjectType` name that is used to resolve profile merging conflicts when choosing `SOURCE` as the `ConflictResolvingModel`.
 */
public data class DomainRuleBasedMatchingConflictResolution(
    public val conflictResolvingModel: String,
    public val sourceName: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.customerprofiles.outputs.DomainRuleBasedMatchingConflictResolution): DomainRuleBasedMatchingConflictResolution = DomainRuleBasedMatchingConflictResolution(
            conflictResolvingModel = javaType.conflictResolvingModel(),
            sourceName = javaType.sourceName().map({ args0 -> args0 }).orElse(null),
        )
    }
}
