@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.customerprofiles.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property s3BucketName The name of the S3 bucket where Identity Resolution Jobs write result files.
 * @property s3KeyName The S3 key name of the location where Identity Resolution Jobs write result files.
 */
public data class DomainRuleBasedMatchingExportingConfigS3Exporting(
    public val s3BucketName: String,
    public val s3KeyName: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.customerprofiles.outputs.DomainRuleBasedMatchingExportingConfigS3Exporting): DomainRuleBasedMatchingExportingConfigS3Exporting =
            DomainRuleBasedMatchingExportingConfigS3Exporting(
                s3BucketName = javaType.s3BucketName(),
                s3KeyName = javaType.s3KeyName().map({ args0 -> args0 }).orElse(null),
            )
    }
}
