@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.customerprofiles.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property address1 The first line of a customer address.
 * @property address2 The second line of a customer address.
 * @property address3 The third line of a customer address.
 * @property address4 The fourth line of a customer address.
 * @property city The city in which a customer lives.
 * @property country The country in which a customer lives.
 * @property county The county in which a customer lives.
 * @property postalCode The postal code of a customer address.
 * @property province The province in which a customer lives.
 * @property state The state in which a customer lives.
 */
public data class ProfileShippingAddress(
    public val address1: String? = null,
    public val address2: String? = null,
    public val address3: String? = null,
    public val address4: String? = null,
    public val city: String? = null,
    public val country: String? = null,
    public val county: String? = null,
    public val postalCode: String? = null,
    public val province: String? = null,
    public val state: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.customerprofiles.outputs.ProfileShippingAddress): ProfileShippingAddress = ProfileShippingAddress(
            address1 = javaType.address1().map({ args0 -> args0 }).orElse(null),
            address2 = javaType.address2().map({ args0 -> args0 }).orElse(null),
            address3 = javaType.address3().map({ args0 -> args0 }).orElse(null),
            address4 = javaType.address4().map({ args0 -> args0 }).orElse(null),
            city = javaType.city().map({ args0 -> args0 }).orElse(null),
            country = javaType.country().map({ args0 -> args0 }).orElse(null),
            county = javaType.county().map({ args0 -> args0 }).orElse(null),
            postalCode = javaType.postalCode().map({ args0 -> args0 }).orElse(null),
            province = javaType.province().map({ args0 -> args0 }).orElse(null),
            state = javaType.state().map({ args0 -> args0 }).orElse(null),
        )
    }
}
