@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.dataexchange.kotlin

import com.pulumi.aws.dataexchange.RevisionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a resource to manage AWS Data Exchange Revisions.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.dataexchange.Revision("example", {dataSetId: exampleAwsDataexchangeDataSet.id});
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.dataexchange.Revision("example", data_set_id=example_aws_dataexchange_data_set["id"])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.DataExchange.Revision("example", new()
 *     {
 *         DataSetId = exampleAwsDataexchangeDataSet.Id,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/dataexchange"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := dataexchange.NewRevision(ctx, "example", &dataexchange.RevisionArgs{
 * 			DataSetId: pulumi.Any(exampleAwsDataexchangeDataSet.Id),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.dataexchange.Revision;
 * import com.pulumi.aws.dataexchange.RevisionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Revision("example", RevisionArgs.builder()
 *             .dataSetId(exampleAwsDataexchangeDataSet.id())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:dataexchange:Revision
 *     properties:
 *       dataSetId: ${exampleAwsDataexchangeDataSet.id}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import DataExchange Revisions using their `data-set-id:revision-id`. For example:
 * ```sh
 * $ pulumi import aws:dataexchange/revision:Revision example 4fa784c7-ccb4-4dbf-ba4f-02198320daa1:4fa784c7-ccb4-4dbf-ba4f-02198320daa1
 * ```
 * @property comment An optional comment about the revision.
 * @property dataSetId The dataset id.
 * @property tags A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class RevisionArgs(
    public val comment: Output<String>? = null,
    public val dataSetId: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.dataexchange.RevisionArgs> {
    override fun toJava(): com.pulumi.aws.dataexchange.RevisionArgs =
        com.pulumi.aws.dataexchange.RevisionArgs.builder()
            .comment(comment?.applyValue({ args0 -> args0 }))
            .dataSetId(dataSetId?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [RevisionArgs].
 */
@PulumiTagMarker
public class RevisionArgsBuilder internal constructor() {
    private var comment: Output<String>? = null

    private var dataSetId: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value An optional comment about the revision.
     */
    @JvmName("ljongjtirqgmcfnk")
    public suspend fun comment(`value`: Output<String>) {
        this.comment = value
    }

    /**
     * @param value The dataset id.
     */
    @JvmName("wybjxuhwfupwotuh")
    public suspend fun dataSetId(`value`: Output<String>) {
        this.dataSetId = value
    }

    /**
     * @param value A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("jehjlhfmotkyygdi")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value An optional comment about the revision.
     */
    @JvmName("flxglbbvghsrabuw")
    public suspend fun comment(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.comment = mapped
    }

    /**
     * @param value The dataset id.
     */
    @JvmName("dadqwooginvpiomc")
    public suspend fun dataSetId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dataSetId = mapped
    }

    /**
     * @param value A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("ftoulanhltsrdtyd")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("yyeeujkaverkrrkd")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): RevisionArgs = RevisionArgs(
        comment = comment,
        dataSetId = dataSetId,
        tags = tags,
    )
}
