@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.datapipeline.kotlin

import com.pulumi.aws.datapipeline.PipelineDefinitionArgs.builder
import com.pulumi.aws.datapipeline.kotlin.inputs.PipelineDefinitionParameterObjectArgs
import com.pulumi.aws.datapipeline.kotlin.inputs.PipelineDefinitionParameterObjectArgsBuilder
import com.pulumi.aws.datapipeline.kotlin.inputs.PipelineDefinitionParameterValueArgs
import com.pulumi.aws.datapipeline.kotlin.inputs.PipelineDefinitionParameterValueArgsBuilder
import com.pulumi.aws.datapipeline.kotlin.inputs.PipelineDefinitionPipelineObjectArgs
import com.pulumi.aws.datapipeline.kotlin.inputs.PipelineDefinitionPipelineObjectArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Provides a DataPipeline Pipeline Definition resource.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const _default = new aws.datapipeline.Pipeline("default", {name: "tf-pipeline-default"});
 * const example = new aws.datapipeline.PipelineDefinition("example", {
 *     pipelineId: _default.id,
 *     pipelineObjects: [
 *         {
 *             id: "Default",
 *             name: "Default",
 *             fields: [{
 *                 key: "workerGroup",
 *                 stringValue: "workerGroup",
 *             }],
 *         },
 *         {
 *             id: "Schedule",
 *             name: "Schedule",
 *             fields: [
 *                 {
 *                     key: "startDateTime",
 *                     stringValue: "2012-12-12T00:00:00",
 *                 },
 *                 {
 *                     key: "type",
 *                     stringValue: "Schedule",
 *                 },
 *                 {
 *                     key: "period",
 *                     stringValue: "1 hour",
 *                 },
 *                 {
 *                     key: "endDateTime",
 *                     stringValue: "2012-12-21T18:00:00",
 *                 },
 *             ],
 *         },
 *         {
 *             id: "SayHello",
 *             name: "SayHello",
 *             fields: [
 *                 {
 *                     key: "type",
 *                     stringValue: "ShellCommandActivity",
 *                 },
 *                 {
 *                     key: "command",
 *                     stringValue: "echo hello",
 *                 },
 *                 {
 *                     key: "parent",
 *                     stringValue: "Default",
 *                 },
 *                 {
 *                     key: "schedule",
 *                     stringValue: "Schedule",
 *                 },
 *             ],
 *         },
 *     ],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * default = aws.datapipeline.Pipeline("default", name="tf-pipeline-default")
 * example = aws.datapipeline.PipelineDefinition("example",
 *     pipeline_id=default.id,
 *     pipeline_objects=[
 *         {
 *             "id": "Default",
 *             "name": "Default",
 *             "fields": [{
 *                 "key": "workerGroup",
 *                 "string_value": "workerGroup",
 *             }],
 *         },
 *         {
 *             "id": "Schedule",
 *             "name": "Schedule",
 *             "fields": [
 *                 {
 *                     "key": "startDateTime",
 *                     "string_value": "2012-12-12T00:00:00",
 *                 },
 *                 {
 *                     "key": "type",
 *                     "string_value": "Schedule",
 *                 },
 *                 {
 *                     "key": "period",
 *                     "string_value": "1 hour",
 *                 },
 *                 {
 *                     "key": "endDateTime",
 *                     "string_value": "2012-12-21T18:00:00",
 *                 },
 *             ],
 *         },
 *         {
 *             "id": "SayHello",
 *             "name": "SayHello",
 *             "fields": [
 *                 {
 *                     "key": "type",
 *                     "string_value": "ShellCommandActivity",
 *                 },
 *                 {
 *                     "key": "command",
 *                     "string_value": "echo hello",
 *                 },
 *                 {
 *                     "key": "parent",
 *                     "string_value": "Default",
 *                 },
 *                 {
 *                     "key": "schedule",
 *                     "string_value": "Schedule",
 *                 },
 *             ],
 *         },
 *     ])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var @default = new Aws.DataPipeline.Pipeline("default", new()
 *     {
 *         Name = "tf-pipeline-default",
 *     });
 *     var example = new Aws.DataPipeline.PipelineDefinition("example", new()
 *     {
 *         PipelineId = @default.Id,
 *         PipelineObjects = new[]
 *         {
 *             new Aws.DataPipeline.Inputs.PipelineDefinitionPipelineObjectArgs
 *             {
 *                 Id = "Default",
 *                 Name = "Default",
 *                 Fields = new[]
 *                 {
 *                     new Aws.DataPipeline.Inputs.PipelineDefinitionPipelineObjectFieldArgs
 *                     {
 *                         Key = "workerGroup",
 *                         StringValue = "workerGroup",
 *                     },
 *                 },
 *             },
 *             new Aws.DataPipeline.Inputs.PipelineDefinitionPipelineObjectArgs
 *             {
 *                 Id = "Schedule",
 *                 Name = "Schedule",
 *                 Fields = new[]
 *                 {
 *                     new Aws.DataPipeline.Inputs.PipelineDefinitionPipelineObjectFieldArgs
 *                     {
 *                         Key = "startDateTime",
 *                         StringValue = "2012-12-12T00:00:00",
 *                     },
 *                     new Aws.DataPipeline.Inputs.PipelineDefinitionPipelineObjectFieldArgs
 *                     {
 *                         Key = "type",
 *                         StringValue = "Schedule",
 *                     },
 *                     new Aws.DataPipeline.Inputs.PipelineDefinitionPipelineObjectFieldArgs
 *                     {
 *                         Key = "period",
 *                         StringValue = "1 hour",
 *                     },
 *                     new Aws.DataPipeline.Inputs.PipelineDefinitionPipelineObjectFieldArgs
 *                     {
 *                         Key = "endDateTime",
 *                         StringValue = "2012-12-21T18:00:00",
 *                     },
 *                 },
 *             },
 *             new Aws.DataPipeline.Inputs.PipelineDefinitionPipelineObjectArgs
 *             {
 *                 Id = "SayHello",
 *                 Name = "SayHello",
 *                 Fields = new[]
 *                 {
 *                     new Aws.DataPipeline.Inputs.PipelineDefinitionPipelineObjectFieldArgs
 *                     {
 *                         Key = "type",
 *                         StringValue = "ShellCommandActivity",
 *                     },
 *                     new Aws.DataPipeline.Inputs.PipelineDefinitionPipelineObjectFieldArgs
 *                     {
 *                         Key = "command",
 *                         StringValue = "echo hello",
 *                     },
 *                     new Aws.DataPipeline.Inputs.PipelineDefinitionPipelineObjectFieldArgs
 *                     {
 *                         Key = "parent",
 *                         StringValue = "Default",
 *                     },
 *                     new Aws.DataPipeline.Inputs.PipelineDefinitionPipelineObjectFieldArgs
 *                     {
 *                         Key = "schedule",
 *                         StringValue = "Schedule",
 *                     },
 *                 },
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/datapipeline"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := datapipeline.NewPipeline(ctx, "default", &datapipeline.PipelineArgs{
 * 			Name: pulumi.String("tf-pipeline-default"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = datapipeline.NewPipelineDefinition(ctx, "example", &datapipeline.PipelineDefinitionArgs{
 * 			PipelineId: _default.ID(),
 * 			PipelineObjects: datapipeline.PipelineDefinitionPipelineObjectArray{
 * 				&datapipeline.PipelineDefinitionPipelineObjectArgs{
 * 					Id:   pulumi.String("Default"),
 * 					Name: pulumi.String("Default"),
 * 					Fields: datapipeline.PipelineDefinitionPipelineObjectFieldArray{
 * 						&datapipeline.PipelineDefinitionPipelineObjectFieldArgs{
 * 							Key:         pulumi.String("workerGroup"),
 * 							StringValue: pulumi.String("workerGroup"),
 * 						},
 * 					},
 * 				},
 * 				&datapipeline.PipelineDefinitionPipelineObjectArgs{
 * 					Id:   pulumi.String("Schedule"),
 * 					Name: pulumi.String("Schedule"),
 * 					Fields: datapipeline.PipelineDefinitionPipelineObjectFieldArray{
 * 						&datapipeline.PipelineDefinitionPipelineObjectFieldArgs{
 * 							Key:         pulumi.String("startDateTime"),
 * 							StringValue: pulumi.String("2012-12-12T00:00:00"),
 * 						},
 * 						&datapipeline.PipelineDefinitionPipelineObjectFieldArgs{
 * 							Key:         pulumi.String("type"),
 * 							StringValue: pulumi.String("Schedule"),
 * 						},
 * 						&datapipeline.PipelineDefinitionPipelineObjectFieldArgs{
 * 							Key:         pulumi.String("period"),
 * 							StringValue: pulumi.String("1 hour"),
 * 						},
 * 						&datapipeline.PipelineDefinitionPipelineObjectFieldArgs{
 * 							Key:         pulumi.String("endDateTime"),
 * 							StringValue: pulumi.String("2012-12-21T18:00:00"),
 * 						},
 * 					},
 * 				},
 * 				&datapipeline.PipelineDefinitionPipelineObjectArgs{
 * 					Id:   pulumi.String("SayHello"),
 * 					Name: pulumi.String("SayHello"),
 * 					Fields: datapipeline.PipelineDefinitionPipelineObjectFieldArray{
 * 						&datapipeline.PipelineDefinitionPipelineObjectFieldArgs{
 * 							Key:         pulumi.String("type"),
 * 							StringValue: pulumi.String("ShellCommandActivity"),
 * 						},
 * 						&datapipeline.PipelineDefinitionPipelineObjectFieldArgs{
 * 							Key:         pulumi.String("command"),
 * 							StringValue: pulumi.String("echo hello"),
 * 						},
 * 						&datapipeline.PipelineDefinitionPipelineObjectFieldArgs{
 * 							Key:         pulumi.String("parent"),
 * 							StringValue: pulumi.String("Default"),
 * 						},
 * 						&datapipeline.PipelineDefinitionPipelineObjectFieldArgs{
 * 							Key:         pulumi.String("schedule"),
 * 							StringValue: pulumi.String("Schedule"),
 * 						},
 * 					},
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.datapipeline.Pipeline;
 * import com.pulumi.aws.datapipeline.PipelineArgs;
 * import com.pulumi.aws.datapipeline.PipelineDefinition;
 * import com.pulumi.aws.datapipeline.PipelineDefinitionArgs;
 * import com.pulumi.aws.datapipeline.inputs.PipelineDefinitionPipelineObjectArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var default_ = new Pipeline("default", PipelineArgs.builder()
 *             .name("tf-pipeline-default")
 *             .build());
 *         var example = new PipelineDefinition("example", PipelineDefinitionArgs.builder()
 *             .pipelineId(default_.id())
 *             .pipelineObjects(
 *                 PipelineDefinitionPipelineObjectArgs.builder()
 *                     .id("Default")
 *                     .name("Default")
 *                     .fields(PipelineDefinitionPipelineObjectFieldArgs.builder()
 *                         .key("workerGroup")
 *                         .stringValue("workerGroup")
 *                         .build())
 *                     .build(),
 *                 PipelineDefinitionPipelineObjectArgs.builder()
 *                     .id("Schedule")
 *                     .name("Schedule")
 *                     .fields(
 *                         PipelineDefinitionPipelineObjectFieldArgs.builder()
 *                             .key("startDateTime")
 *                             .stringValue("2012-12-12T00:00:00")
 *                             .build(),
 *                         PipelineDefinitionPipelineObjectFieldArgs.builder()
 *                             .key("type")
 *                             .stringValue("Schedule")
 *                             .build(),
 *                         PipelineDefinitionPipelineObjectFieldArgs.builder()
 *                             .key("period")
 *                             .stringValue("1 hour")
 *                             .build(),
 *                         PipelineDefinitionPipelineObjectFieldArgs.builder()
 *                             .key("endDateTime")
 *                             .stringValue("2012-12-21T18:00:00")
 *                             .build())
 *                     .build(),
 *                 PipelineDefinitionPipelineObjectArgs.builder()
 *                     .id("SayHello")
 *                     .name("SayHello")
 *                     .fields(
 *                         PipelineDefinitionPipelineObjectFieldArgs.builder()
 *                             .key("type")
 *                             .stringValue("ShellCommandActivity")
 *                             .build(),
 *                         PipelineDefinitionPipelineObjectFieldArgs.builder()
 *                             .key("command")
 *                             .stringValue("echo hello")
 *                             .build(),
 *                         PipelineDefinitionPipelineObjectFieldArgs.builder()
 *                             .key("parent")
 *                             .stringValue("Default")
 *                             .build(),
 *                         PipelineDefinitionPipelineObjectFieldArgs.builder()
 *                             .key("schedule")
 *                             .stringValue("Schedule")
 *                             .build())
 *                     .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   default:
 *     type: aws:datapipeline:Pipeline
 *     properties:
 *       name: tf-pipeline-default
 *   example:
 *     type: aws:datapipeline:PipelineDefinition
 *     properties:
 *       pipelineId: ${default.id}
 *       pipelineObjects:
 *         - id: Default
 *           name: Default
 *           fields:
 *             - key: workerGroup
 *               stringValue: workerGroup
 *         - id: Schedule
 *           name: Schedule
 *           fields:
 *             - key: startDateTime
 *               stringValue: 2012-12-12T00:00:00
 *             - key: type
 *               stringValue: Schedule
 *             - key: period
 *               stringValue: 1 hour
 *             - key: endDateTime
 *               stringValue: 2012-12-21T18:00:00
 *         - id: SayHello
 *           name: SayHello
 *           fields:
 *             - key: type
 *               stringValue: ShellCommandActivity
 *             - key: command
 *               stringValue: echo hello
 *             - key: parent
 *               stringValue: Default
 *             - key: schedule
 *               stringValue: Schedule
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import `aws_datapipeline_pipeline_definition` using the id. For example:
 * ```sh
 * $ pulumi import aws:datapipeline/pipelineDefinition:PipelineDefinition example df-1234567890
 * ```
 * @property parameterObjects Configuration block for the parameter objects used in the pipeline definition. See below
 * @property parameterValues Configuration block for the parameter values used in the pipeline definition. See below
 * @property pipelineId ID of the pipeline.
 * @property pipelineObjects Configuration block for the objects that define the pipeline. See below
 * The following arguments are optional:
 */
public data class PipelineDefinitionArgs(
    public val parameterObjects: Output<List<PipelineDefinitionParameterObjectArgs>>? = null,
    public val parameterValues: Output<List<PipelineDefinitionParameterValueArgs>>? = null,
    public val pipelineId: Output<String>? = null,
    public val pipelineObjects: Output<List<PipelineDefinitionPipelineObjectArgs>>? = null,
) : ConvertibleToJava<com.pulumi.aws.datapipeline.PipelineDefinitionArgs> {
    override fun toJava(): com.pulumi.aws.datapipeline.PipelineDefinitionArgs =
        com.pulumi.aws.datapipeline.PipelineDefinitionArgs.builder()
            .parameterObjects(
                parameterObjects?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .parameterValues(
                parameterValues?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .pipelineId(pipelineId?.applyValue({ args0 -> args0 }))
            .pipelineObjects(
                pipelineObjects?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [PipelineDefinitionArgs].
 */
@PulumiTagMarker
public class PipelineDefinitionArgsBuilder internal constructor() {
    private var parameterObjects: Output<List<PipelineDefinitionParameterObjectArgs>>? = null

    private var parameterValues: Output<List<PipelineDefinitionParameterValueArgs>>? = null

    private var pipelineId: Output<String>? = null

    private var pipelineObjects: Output<List<PipelineDefinitionPipelineObjectArgs>>? = null

    /**
     * @param value Configuration block for the parameter objects used in the pipeline definition. See below
     */
    @JvmName("chudqilwtkufnjvt")
    public suspend fun parameterObjects(`value`: Output<List<PipelineDefinitionParameterObjectArgs>>) {
        this.parameterObjects = value
    }

    @JvmName("ywdnegpsiuiflxgf")
    public suspend fun parameterObjects(vararg values: Output<PipelineDefinitionParameterObjectArgs>) {
        this.parameterObjects = Output.all(values.asList())
    }

    /**
     * @param values Configuration block for the parameter objects used in the pipeline definition. See below
     */
    @JvmName("lmofrvaufyrbsqot")
    public suspend fun parameterObjects(values: List<Output<PipelineDefinitionParameterObjectArgs>>) {
        this.parameterObjects = Output.all(values)
    }

    /**
     * @param value Configuration block for the parameter values used in the pipeline definition. See below
     */
    @JvmName("qxpdffagyjsqrltr")
    public suspend fun parameterValues(`value`: Output<List<PipelineDefinitionParameterValueArgs>>) {
        this.parameterValues = value
    }

    @JvmName("budulgcrmbncavrd")
    public suspend fun parameterValues(vararg values: Output<PipelineDefinitionParameterValueArgs>) {
        this.parameterValues = Output.all(values.asList())
    }

    /**
     * @param values Configuration block for the parameter values used in the pipeline definition. See below
     */
    @JvmName("tqxjmxlauxtjbevm")
    public suspend fun parameterValues(values: List<Output<PipelineDefinitionParameterValueArgs>>) {
        this.parameterValues = Output.all(values)
    }

    /**
     * @param value ID of the pipeline.
     */
    @JvmName("bovsnoqyusvmhnds")
    public suspend fun pipelineId(`value`: Output<String>) {
        this.pipelineId = value
    }

    /**
     * @param value Configuration block for the objects that define the pipeline. See below
     * The following arguments are optional:
     */
    @JvmName("itwdurbfndeoedbu")
    public suspend fun pipelineObjects(`value`: Output<List<PipelineDefinitionPipelineObjectArgs>>) {
        this.pipelineObjects = value
    }

    @JvmName("undrdaynoayjqqfj")
    public suspend fun pipelineObjects(vararg values: Output<PipelineDefinitionPipelineObjectArgs>) {
        this.pipelineObjects = Output.all(values.asList())
    }

    /**
     * @param values Configuration block for the objects that define the pipeline. See below
     * The following arguments are optional:
     */
    @JvmName("tgqngobrchschhul")
    public suspend fun pipelineObjects(values: List<Output<PipelineDefinitionPipelineObjectArgs>>) {
        this.pipelineObjects = Output.all(values)
    }

    /**
     * @param value Configuration block for the parameter objects used in the pipeline definition. See below
     */
    @JvmName("airseddbuutpmwrp")
    public suspend fun parameterObjects(`value`: List<PipelineDefinitionParameterObjectArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.parameterObjects = mapped
    }

    /**
     * @param argument Configuration block for the parameter objects used in the pipeline definition. See below
     */
    @JvmName("jaagmjkkyyrlcmhi")
    public suspend fun parameterObjects(argument: List<suspend PipelineDefinitionParameterObjectArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            PipelineDefinitionParameterObjectArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.parameterObjects = mapped
    }

    /**
     * @param argument Configuration block for the parameter objects used in the pipeline definition. See below
     */
    @JvmName("dyaeamfgnnarsyld")
    public suspend fun parameterObjects(vararg argument: suspend PipelineDefinitionParameterObjectArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            PipelineDefinitionParameterObjectArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.parameterObjects = mapped
    }

    /**
     * @param argument Configuration block for the parameter objects used in the pipeline definition. See below
     */
    @JvmName("qmhgldyfeofwirxw")
    public suspend fun parameterObjects(argument: suspend PipelineDefinitionParameterObjectArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            PipelineDefinitionParameterObjectArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.parameterObjects = mapped
    }

    /**
     * @param values Configuration block for the parameter objects used in the pipeline definition. See below
     */
    @JvmName("tfhyulwcmokarqfu")
    public suspend fun parameterObjects(vararg values: PipelineDefinitionParameterObjectArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.parameterObjects = mapped
    }

    /**
     * @param value Configuration block for the parameter values used in the pipeline definition. See below
     */
    @JvmName("kxodcaxirpqsyhrb")
    public suspend fun parameterValues(`value`: List<PipelineDefinitionParameterValueArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.parameterValues = mapped
    }

    /**
     * @param argument Configuration block for the parameter values used in the pipeline definition. See below
     */
    @JvmName("oblphnskiqoyojyh")
    public suspend fun parameterValues(argument: List<suspend PipelineDefinitionParameterValueArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            PipelineDefinitionParameterValueArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.parameterValues = mapped
    }

    /**
     * @param argument Configuration block for the parameter values used in the pipeline definition. See below
     */
    @JvmName("royoiloxlxdebdyi")
    public suspend fun parameterValues(vararg argument: suspend PipelineDefinitionParameterValueArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            PipelineDefinitionParameterValueArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.parameterValues = mapped
    }

    /**
     * @param argument Configuration block for the parameter values used in the pipeline definition. See below
     */
    @JvmName("ecdbkdprikrfbjiw")
    public suspend fun parameterValues(argument: suspend PipelineDefinitionParameterValueArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            PipelineDefinitionParameterValueArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.parameterValues = mapped
    }

    /**
     * @param values Configuration block for the parameter values used in the pipeline definition. See below
     */
    @JvmName("dhnpexmkefterynr")
    public suspend fun parameterValues(vararg values: PipelineDefinitionParameterValueArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.parameterValues = mapped
    }

    /**
     * @param value ID of the pipeline.
     */
    @JvmName("xhillcrqcestqexf")
    public suspend fun pipelineId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.pipelineId = mapped
    }

    /**
     * @param value Configuration block for the objects that define the pipeline. See below
     * The following arguments are optional:
     */
    @JvmName("jhlswardxbvhtawk")
    public suspend fun pipelineObjects(`value`: List<PipelineDefinitionPipelineObjectArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.pipelineObjects = mapped
    }

    /**
     * @param argument Configuration block for the objects that define the pipeline. See below
     * The following arguments are optional:
     */
    @JvmName("btwlgnwlmigmambt")
    public suspend fun pipelineObjects(argument: List<suspend PipelineDefinitionPipelineObjectArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            PipelineDefinitionPipelineObjectArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.pipelineObjects = mapped
    }

    /**
     * @param argument Configuration block for the objects that define the pipeline. See below
     * The following arguments are optional:
     */
    @JvmName("njncununytvgsrrm")
    public suspend fun pipelineObjects(vararg argument: suspend PipelineDefinitionPipelineObjectArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            PipelineDefinitionPipelineObjectArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.pipelineObjects = mapped
    }

    /**
     * @param argument Configuration block for the objects that define the pipeline. See below
     * The following arguments are optional:
     */
    @JvmName("parnpgucyusvgtdx")
    public suspend fun pipelineObjects(argument: suspend PipelineDefinitionPipelineObjectArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            PipelineDefinitionPipelineObjectArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.pipelineObjects = mapped
    }

    /**
     * @param values Configuration block for the objects that define the pipeline. See below
     * The following arguments are optional:
     */
    @JvmName("nnbhqfravmniidtb")
    public suspend fun pipelineObjects(vararg values: PipelineDefinitionPipelineObjectArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.pipelineObjects = mapped
    }

    internal fun build(): PipelineDefinitionArgs = PipelineDefinitionArgs(
        parameterObjects = parameterObjects,
        parameterValues = parameterValues,
        pipelineId = pipelineId,
        pipelineObjects = pipelineObjects,
    )
}
