@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.datapipeline.kotlin.inputs

import com.pulumi.aws.datapipeline.inputs.GetPipelineDefinitionParameterValue.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property id ID of the object.
 * @property stringValue Field value, expressed as a String.
 */
public data class GetPipelineDefinitionParameterValue(
    public val id: String,
    public val stringValue: String,
) : ConvertibleToJava<com.pulumi.aws.datapipeline.inputs.GetPipelineDefinitionParameterValue> {
    override fun toJava(): com.pulumi.aws.datapipeline.inputs.GetPipelineDefinitionParameterValue =
        com.pulumi.aws.datapipeline.inputs.GetPipelineDefinitionParameterValue.builder()
            .id(id.let({ args0 -> args0 }))
            .stringValue(stringValue.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetPipelineDefinitionParameterValue].
 */
@PulumiTagMarker
public class GetPipelineDefinitionParameterValueBuilder internal constructor() {
    private var id: String? = null

    private var stringValue: String? = null

    /**
     * @param value ID of the object.
     */
    @JvmName("ouofgquqfmnasfhk")
    public suspend fun id(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.id = mapped
    }

    /**
     * @param value Field value, expressed as a String.
     */
    @JvmName("okewckyucgdwyfld")
    public suspend fun stringValue(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.stringValue = mapped
    }

    internal fun build(): GetPipelineDefinitionParameterValue = GetPipelineDefinitionParameterValue(
        id = id ?: throw PulumiNullFieldException("id"),
        stringValue = stringValue ?: throw PulumiNullFieldException("stringValue"),
    )
}
