@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.datapipeline.kotlin.inputs

import com.pulumi.aws.datapipeline.inputs.GetPipelineDefinitionPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getPipelineDefinition.
 * @property parameterValues Parameter values used in the pipeline definition. See below
 * @property pipelineId ID of the pipeline.
 */
public data class GetPipelineDefinitionPlainArgs(
    public val parameterValues: List<GetPipelineDefinitionParameterValue>? = null,
    public val pipelineId: String,
) : ConvertibleToJava<com.pulumi.aws.datapipeline.inputs.GetPipelineDefinitionPlainArgs> {
    override fun toJava(): com.pulumi.aws.datapipeline.inputs.GetPipelineDefinitionPlainArgs =
        com.pulumi.aws.datapipeline.inputs.GetPipelineDefinitionPlainArgs.builder()
            .parameterValues(
                parameterValues?.let({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .pipelineId(pipelineId.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetPipelineDefinitionPlainArgs].
 */
@PulumiTagMarker
public class GetPipelineDefinitionPlainArgsBuilder internal constructor() {
    private var parameterValues: List<GetPipelineDefinitionParameterValue>? = null

    private var pipelineId: String? = null

    /**
     * @param value Parameter values used in the pipeline definition. See below
     */
    @JvmName("hpfefdtfucgcxleq")
    public suspend fun parameterValues(`value`: List<GetPipelineDefinitionParameterValue>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.parameterValues = mapped
    }

    /**
     * @param argument Parameter values used in the pipeline definition. See below
     */
    @JvmName("crnyqpsvdlehbrsm")
    public suspend fun parameterValues(argument: List<suspend GetPipelineDefinitionParameterValueBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            GetPipelineDefinitionParameterValueBuilder().applySuspend { it() }.build()
        }
        val mapped = toBeMapped
        this.parameterValues = mapped
    }

    /**
     * @param argument Parameter values used in the pipeline definition. See below
     */
    @JvmName("mnknxfsyvhikcrim")
    public suspend fun parameterValues(vararg argument: suspend GetPipelineDefinitionParameterValueBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            GetPipelineDefinitionParameterValueBuilder().applySuspend { it() }.build()
        }
        val mapped = toBeMapped
        this.parameterValues = mapped
    }

    /**
     * @param argument Parameter values used in the pipeline definition. See below
     */
    @JvmName("xytlpmgrkvxakklg")
    public suspend fun parameterValues(argument: suspend GetPipelineDefinitionParameterValueBuilder.() -> Unit) {
        val toBeMapped = listOf(
            GetPipelineDefinitionParameterValueBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = toBeMapped
        this.parameterValues = mapped
    }

    /**
     * @param values Parameter values used in the pipeline definition. See below
     */
    @JvmName("onouueqitgksafhe")
    public suspend fun parameterValues(vararg values: GetPipelineDefinitionParameterValue) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.parameterValues = mapped
    }

    /**
     * @param value ID of the pipeline.
     */
    @JvmName("hlabrkkhoooubdty")
    public suspend fun pipelineId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.pipelineId = mapped
    }

    internal fun build(): GetPipelineDefinitionPlainArgs = GetPipelineDefinitionPlainArgs(
        parameterValues = parameterValues,
        pipelineId = pipelineId ?: throw PulumiNullFieldException("pipelineId"),
    )
}
